/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CoderResult;

public class CharsetCallback {
    private static final String SUB_STOP_ON_ILLEGAL = "i";
    private static final String ESCAPE_JAVA = "J";
    private static final String ESCAPE_C = "C";
    private static final String ESCAPE_XML_DEC = "D";
    private static final String ESCAPE_XML_HEX = "X";
    private static final String ESCAPE_UNICODE = "U";
    private static final String ESCAPE_CSS2 = "S";
    public static final Encoder FROM_U_CALLBACK_SKIP = new Encoder(){

        public CoderResult call(CharsetEncoderICU encoder, Object context, CharBuffer source, ByteBuffer target, IntBuffer offsets, char[] buffer, int length, int cp, CoderResult cr) {
            if (context == null) {
                return CoderResult.UNDERFLOW;
            }
            if (((String)context).equals(CharsetCallback.SUB_STOP_ON_ILLEGAL)) {
                if (!cr.isUnmappable()) {
                    return cr;
                }
                return CoderResult.UNDERFLOW;
            }
            return cr;
        }
    };
    public static final Decoder TO_U_CALLBACK_SKIP = new Decoder(){

        public CoderResult call(CharsetDecoderICU decoder, Object context, ByteBuffer source, CharBuffer target, IntBuffer offsets, char[] buffer, int length, CoderResult cr) {
            if (context == null) {
                return CoderResult.UNDERFLOW;
            }
            if (((String)context).equals(CharsetCallback.SUB_STOP_ON_ILLEGAL)) {
                if (!cr.isUnmappable()) {
                    return cr;
                }
                return CoderResult.UNDERFLOW;
            }
            return cr;
        }
    };
    public static final Encoder FROM_U_CALLBACK_SUBSTITUTE = new Encoder(){

        public CoderResult call(CharsetEncoderICU encoder, Object context, CharBuffer source, ByteBuffer target, IntBuffer offsets, char[] buffer, int length, int cp, CoderResult cr) {
            if (context == null) {
                return encoder.cbFromUWriteSub(encoder, source, target, offsets);
            }
            if (((String)context).equals(CharsetCallback.SUB_STOP_ON_ILLEGAL)) {
                if (!cr.isUnmappable()) {
                    return cr;
                }
                return encoder.cbFromUWriteSub(encoder, source, target, offsets);
            }
            return cr;
        }
    };
    private static final char[] kSubstituteChar1 = new char[]{'\u001a'};
    private static final char[] kSubstituteChar = new char[]{'\ufffd'};
    public static final Decoder TO_U_CALLBACK_SUBSTITUTE = new Decoder(){

        public CoderResult call(CharsetDecoderICU decoder, Object context, ByteBuffer source, CharBuffer target, IntBuffer offsets, char[] buffer, int length, CoderResult cr) {
            CharsetICU cs = (CharsetICU)decoder.charset();
            if (decoder.invalidCharLength == 1 && cs.subChar1 != 0) {
                return CharsetDecoderICU.toUWriteUChars(decoder, kSubstituteChar1, 0, 1, target, offsets, source.position());
            }
            return CharsetDecoderICU.toUWriteUChars(decoder, kSubstituteChar, 0, 1, target, offsets, source.position());
        }
    };
    public static final Encoder FROM_U_CALLBACK_STOP = new Encoder(){

        public CoderResult call(CharsetEncoderICU encoder, Object context, CharBuffer source, ByteBuffer target, IntBuffer offsets, char[] buffer, int length, int cp, CoderResult cr) {
            return cr;
        }
    };
    public static final Decoder TO_U_CALLBACK_STOP = new Decoder(){

        public CoderResult call(CharsetDecoderICU decoder, Object context, ByteBuffer source, CharBuffer target, IntBuffer offsets, char[] buffer, int length, CoderResult cr) {
            return cr;
        }
    };
    private static final int VALUE_STRING_LENGTH = 32;
    private static final char UNICODE_PERCENT_SIGN_CODEPOINT = '%';
    private static final char UNICODE_U_CODEPOINT = 'U';
    private static final char UNICODE_X_CODEPOINT = 'X';
    private static final char UNICODE_RS_CODEPOINT = '\\';
    private static final char UNICODE_U_LOW_CODEPOINT = 'u';
    private static final char UNICODE_X_LOW_CODEPOINT = 'x';
    private static final char UNICODE_AMP_CODEPOINT = '&';
    private static final char UNICODE_HASH_CODEPOINT = '#';
    private static final char UNICODE_SEMICOLON_CODEPOINT = ';';
    private static final char UNICODE_PLUS_CODEPOINT = '+';
    private static final char UNICODE_LEFT_CURLY_CODEPOINT = '{';
    private static final char UNICODE_RIGHT_CURLY_CODEPOINT = '}';
    private static final char UNICODE_SPACE_CODEPOINT = ' ';
    public static final Encoder FROM_U_CALLBACK_ESCAPE = new Encoder(){

        public CoderResult call(CharsetEncoderICU encoder, Object context, CharBuffer source, ByteBuffer target, IntBuffer offsets, char[] buffer, int length, int cp, CoderResult cr) {
            char[] valueString = new char[32];
            int valueStringLength = 0;
            int i = 0;
            cr = CoderResult.UNDERFLOW;
            if (context == null || !(context instanceof String)) {
                while (i < length) {
                    valueString[valueStringLength++] = 37;
                    valueString[valueStringLength++] = 85;
                    valueStringLength += CharsetCallback.itou(valueString, valueStringLength, buffer[i++] & 0xFFFF, 16, 4);
                }
            } else if (((String)context).equals(CharsetCallback.ESCAPE_JAVA)) {
                while (i < length) {
                    valueString[valueStringLength++] = 92;
                    valueString[valueStringLength++] = 117;
                    valueStringLength += CharsetCallback.itou(valueString, valueStringLength, buffer[i++] & 0xFFFF, 16, 4);
                }
            } else if (((String)context).equals(CharsetCallback.ESCAPE_C)) {
                valueString[valueStringLength++] = 92;
                if (length == 2) {
                    valueString[valueStringLength++] = 85;
                    valueStringLength = CharsetCallback.itou(valueString, valueStringLength, cp, 16, 8);
                } else {
                    valueString[valueStringLength++] = 117;
                    valueStringLength += CharsetCallback.itou(valueString, valueStringLength, buffer[0] & 0xFFFF, 16, 4);
                }
            } else if (((String)context).equals(CharsetCallback.ESCAPE_XML_DEC)) {
                valueString[valueStringLength++] = 38;
                valueString[valueStringLength++] = 35;
                valueStringLength = length == 2 ? (valueStringLength += CharsetCallback.itou(valueString, valueStringLength, cp, 10, 0)) : (valueStringLength += CharsetCallback.itou(valueString, valueStringLength, buffer[0] & 0xFFFF, 10, 0));
                valueString[valueStringLength++] = 59;
            } else if (((String)context).equals(CharsetCallback.ESCAPE_XML_HEX)) {
                valueString[valueStringLength++] = 38;
                valueString[valueStringLength++] = 35;
                valueString[valueStringLength++] = 120;
                valueStringLength = length == 2 ? (valueStringLength += CharsetCallback.itou(valueString, valueStringLength, cp, 16, 0)) : (valueStringLength += CharsetCallback.itou(valueString, valueStringLength, buffer[0] & 0xFFFF, 16, 0));
                valueString[valueStringLength++] = 59;
            } else if (((String)context).equals(CharsetCallback.ESCAPE_UNICODE)) {
                valueString[valueStringLength++] = 123;
                valueString[valueStringLength++] = 85;
                valueString[valueStringLength++] = 43;
                valueStringLength = length == 2 ? (valueStringLength += CharsetCallback.itou(valueString, valueStringLength, cp, 16, 4)) : (valueStringLength += CharsetCallback.itou(valueString, valueStringLength, buffer[0] & 0xFFFF, 16, 4));
                valueString[valueStringLength++] = 125;
            } else if (((String)context).equals(CharsetCallback.ESCAPE_CSS2)) {
                valueString[valueStringLength++] = 92;
                valueStringLength += CharsetCallback.itou(valueString, valueStringLength, cp, 16, 0);
                valueString[valueStringLength++] = 32;
            } else {
                while (i < length) {
                    valueString[valueStringLength++] = 37;
                    valueString[valueStringLength++] = 85;
                    valueStringLength += CharsetCallback.itou(valueString, valueStringLength, buffer[i++] & 0xFFFF, 16, 4);
                }
            }
            cr = encoder.cbFromUWriteUChars(encoder, CharBuffer.wrap(valueString, 0, valueStringLength), target, offsets);
            return cr;
        }
    };
    public static final Decoder TO_U_CALLBACK_ESCAPE = new Decoder(){

        public CoderResult call(CharsetDecoderICU decoder, Object context, ByteBuffer source, CharBuffer target, IntBuffer offsets, char[] buffer, int length, CoderResult cr) {
            char[] uniValueString = new char[32];
            int valueStringLength = 0;
            int i = 0;
            if (context == null || !(context instanceof String)) {
                while (i < length) {
                    uniValueString[valueStringLength++] = 37;
                    uniValueString[valueStringLength++] = 88;
                    valueStringLength += CharsetCallback.itou(uniValueString, valueStringLength, buffer[i++] & 0xFF, 16, 2);
                }
            } else if (((String)context).equals(CharsetCallback.ESCAPE_XML_DEC)) {
                while (i < length) {
                    uniValueString[valueStringLength++] = 38;
                    uniValueString[valueStringLength++] = 35;
                    valueStringLength += CharsetCallback.itou(uniValueString, valueStringLength, buffer[i++] & 0xFF, 10, 0);
                    uniValueString[valueStringLength++] = 59;
                }
            } else if (((String)context).equals(CharsetCallback.ESCAPE_XML_HEX)) {
                while (i < length) {
                    uniValueString[valueStringLength++] = 38;
                    uniValueString[valueStringLength++] = 35;
                    uniValueString[valueStringLength++] = 120;
                    valueStringLength += CharsetCallback.itou(uniValueString, valueStringLength, buffer[i++] & 0xFF, 16, 0);
                    uniValueString[valueStringLength++] = 59;
                }
            } else if (((String)context).equals(CharsetCallback.ESCAPE_C)) {
                while (i < length) {
                    uniValueString[valueStringLength++] = 92;
                    uniValueString[valueStringLength++] = 120;
                    valueStringLength += CharsetCallback.itou(uniValueString, valueStringLength, buffer[i++] & 0xFF, 16, 2);
                }
            } else {
                while (i < length) {
                    uniValueString[valueStringLength++] = 37;
                    uniValueString[valueStringLength++] = 88;
                    CharsetCallback.itou(uniValueString, valueStringLength, buffer[i++] & 0xFF, 16, 2);
                    valueStringLength += 2;
                }
            }
            cr = CharsetDecoderICU.toUWriteUChars(decoder, uniValueString, 0, valueStringLength, target, offsets, 0);
            return cr;
        }
    };

    private static final int itou(char[] buffer, int sourceIndex, int i, int radix, int minwidth) {
        int length = 0;
        do {
            int digit = i % radix;
            buffer[sourceIndex + length++] = (char)(digit <= 9 ? 48 + digit : 48 + digit + 7);
        } while ((i /= radix) != 0 && sourceIndex + length < buffer.length);
        while (length < minwidth) {
            buffer[sourceIndex + length++] = 48;
        }
        for (int j = 0; j < length / 2; ++j) {
            char temp = buffer[sourceIndex + length - 1 - j];
            buffer[sourceIndex + length - 1 - j] = buffer[sourceIndex + j];
            buffer[sourceIndex + j] = temp;
        }
        return length;
    }

    public static interface Encoder {
        public CoderResult call(CharsetEncoderICU var1, Object var2, CharBuffer var3, ByteBuffer var4, IntBuffer var5, char[] var6, int var7, int var8, CoderResult var9);
    }

    public static interface Decoder {
        public CoderResult call(CharsetDecoderICU var1, Object var2, ByteBuffer var3, CharBuffer var4, IntBuffer var5, char[] var6, int var7, CoderResult var8);
    }
}

