/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.verify;

import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import net.sf.jsignpdf.types.CertificationLevel;

public class SignatureVerification {
    public static final int SIG_STAT_CODE_ERROR_REVISION_MODIFIED = 120;
    public static final int SIG_STAT_CODE_ERROR_CERTIFICATION_BROKEN = 110;
    public static final int SIG_STAT_CODE_WARNING_UNSIGNED_CONTENT = 70;
    public static final int SIG_STAT_CODE_WARNING_CERTIFICATE_CANT_BE_VERIFIED = 60;
    public static final int SIG_STAT_CODE_WARNING_CERTIFICATE_EXPIRED = 61;
    public static final int SIG_STAT_CODE_WARNING_CERTIFICATE_NOT_YET_VALID = 62;
    public static final int SIG_STAT_CODE_WARNING_CERTIFICATE_REVOKED = 63;
    public static final int SIG_STAT_CODE_WARNING_CERTIFICATE_UNSUPPORTED_CRITICAL_EXTENSION = 64;
    public static final int SIG_STAT_CODE_WARNING_CERTIFICATE_INVALID_STATE = 65;
    public static final int SIG_STAT_CODE_WARNING_CERTIFICATE_PROBLEM = 66;
    public static final int SIG_STAT_CODE_WARNING_SIGNATURE_OCSP_INVALID = 50;
    public static final int SIG_STAT_CODE_WARNING_NO_TIMESTAMP_TOKEN = 40;
    public static final int SIG_STAT_CODE_WARNING_TIMESTAMP_INVALID = 30;
    public static final int SIG_STAT_CODE_WARNING_NO_REVOCATION_INFO = 20;
    public static final int SIG_STAT_CODE_INFO_SIGNATURE_VALID = 0;
    private static final String CERT_PROBLEM_CANT_BE_VERIFIED = "Cannot be verified against the KeyStore";
    private static final String CERT_PROBLEM_EXPIRED = "certificate expired on";
    private static final String CERT_PROBLEM_NOT_YET_VALID = "certificate not valid till";
    private static final String CERT_PROBLEM_REVOKED = "Certificate revoked";
    private static final String CERT_PROBLEM_UNSUPPORTED_CRITICAL_EXTENSION = "Has unsupported critical extension";
    private static final String CERT_PROBLEM_INVALID_STATE = "Invalid state. Possible circular certificate chain";
    private String signName;
    private String name;
    private String subject;
    private int revision;
    private boolean wholeDocument;
    private Calendar date;
    private boolean modified;
    private boolean ocspPresent;
    private boolean ocspValid;
    private boolean crlPresent;
    private boolean tsTokenPresent;
    private Exception tsTokenValidationResult;
    private Object[] fails;
    private String reason;
    private String location;
    private int certLevelCode;
    private boolean isLastSignature;
    private boolean signCertTrustedAndValid;
    private boolean ocspInCertPresent;
    private boolean ocspInCertValid;
    private X509Certificate signingCertificate;
    private CertPath certPath;

    public SignatureVerification() {
    }

    public SignatureVerification(String aName) {
        this.name = aName;
    }

    public int getValidationCode() {
        int code = 0;
        if (this.isModified()) {
            code = 120;
        } else if (!this.isLastSignature && this.getCertLevelCode() == 1) {
            code = 110;
        } else if (this.isLastSignature && !this.isWholeDocument() && this.getCertLevelCode() != 0) {
            code = 110;
        } else if (this.isLastSignature && !this.isWholeDocument()) {
            code = 70;
        } else if (!this.isSignCertTrustedAndValid() && this.getFails() != null) {
            String errorMessage = String.valueOf(this.getFails()[1]).trim().toLowerCase();
            code = errorMessage.startsWith(CERT_PROBLEM_CANT_BE_VERIFIED.trim().toLowerCase()) ? 60 : (errorMessage.startsWith(CERT_PROBLEM_EXPIRED.trim().toLowerCase()) ? 61 : (errorMessage.startsWith(CERT_PROBLEM_NOT_YET_VALID.trim().toLowerCase()) ? 62 : (errorMessage.startsWith(CERT_PROBLEM_REVOKED.trim().toLowerCase()) ? 63 : (errorMessage.startsWith(CERT_PROBLEM_UNSUPPORTED_CRITICAL_EXTENSION.trim().toLowerCase()) ? 64 : (errorMessage.startsWith(CERT_PROBLEM_INVALID_STATE.trim().toLowerCase()) ? 65 : 66)))));
        } else if (!(this.isCrlPresent() && (!this.isCrlPresent() || this.getFails() == null) || this.isSignCertTrustedAndValid() || !this.isOcspPresent() && !this.isOcspInCertPresent() || this.isOcspValid() || this.isOcspInCertValid())) {
            code = 50;
        } else if (!(this.isSignCertTrustedAndValid() || this.isOcspPresent() || this.isOcspInCertPresent() || this.isCrlPresent())) {
            code = 20;
        } else if (!this.isTsTokenPresent()) {
            code = 40;
        } else if (this.isTsTokenPresent() && this.getTsTokenValidationResult() != null) {
            code = 30;
        }
        return code;
    }

    public static boolean isError(int validationCode) {
        return validationCode >= 100;
    }

    public boolean containsError() {
        return SignatureVerification.isError(this.getValidationCode());
    }

    public static boolean isWarning(int validationCode) {
        return validationCode >= 10 && validationCode < 100;
    }

    public boolean containsWarning() {
        return SignatureVerification.isWarning(this.getValidationCode());
    }

    public static boolean isValidWithoutWarnings(int validationCode) {
        return validationCode == 0;
    }

    public boolean isValidWithoutWarnings() {
        return SignatureVerification.isValidWithoutWarnings(this.getValidationCode());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public boolean isWholeDocument() {
        return this.wholeDocument;
    }

    public void setWholeDocument(boolean wholeDocument) {
        this.wholeDocument = wholeDocument;
    }

    public Calendar getDate() {
        return this.date;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public Object[] getFails() {
        return this.fails;
    }

    public void setFails(Object[] fails) {
        this.fails = fails;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean isOcspPresent() {
        return this.ocspPresent;
    }

    public void setOcspPresent(boolean ocspPresent) {
        this.ocspPresent = ocspPresent;
    }

    public boolean isOcspValid() {
        return this.ocspValid;
    }

    public void setOcspValid(boolean ocspValid) {
        this.ocspValid = ocspValid;
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public boolean isTsTokenPresent() {
        return this.tsTokenPresent;
    }

    public void setTsTokenPresent(boolean tsTokenPresent) {
        this.tsTokenPresent = tsTokenPresent;
    }

    public Exception getTsTokenValidationResult() {
        return this.tsTokenValidationResult;
    }

    public void setTsTokenValidationResult(Exception tsTokenValidationResult) {
        this.tsTokenValidationResult = tsTokenValidationResult;
    }

    public int getCertLevelCode() {
        return this.certLevelCode;
    }

    public void setCertLevelCode(int certLevelCode) {
        this.certLevelCode = certLevelCode;
    }

    public CertificationLevel getCertificationLevel() {
        return CertificationLevel.findCertificationLevel(this.certLevelCode);
    }

    public boolean isSignCertTrustedAndValid() {
        return this.signCertTrustedAndValid;
    }

    public void setSignCertTrustedAndValid(boolean signCertTrustedAndValid) {
        this.signCertTrustedAndValid = signCertTrustedAndValid;
    }

    public boolean isCrlPresent() {
        return this.crlPresent;
    }

    public void setCrlPresent(boolean crlPresent) {
        this.crlPresent = crlPresent;
    }

    public boolean isOcspInCertPresent() {
        return this.ocspInCertPresent;
    }

    public void setOcspInCertPresent(boolean ocspInCertPresent) {
        this.ocspInCertPresent = ocspInCertPresent;
    }

    public boolean isOcspInCertValid() {
        return this.ocspInCertValid;
    }

    public void setOcspInCertValid(boolean ocspInCertValid) {
        this.ocspInCertValid = ocspInCertValid;
    }

    public boolean isLastSignature() {
        return this.isLastSignature;
    }

    public void setLastSignature(boolean isLastSignature) {
        this.isLastSignature = isLastSignature;
    }

    public X509Certificate getSigningCertificate() {
        return this.signingCertificate;
    }

    public void setSigningCertificate(X509Certificate signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public void setCertPath(CertPath certPath) {
        this.certPath = certPath;
    }

    public String toString() {
        return "Signature verification [\n signName=" + this.signName + "\n name=" + this.name + "\n subject=" + this.subject + "\n date=" + this.date.getTime() + "\n reason=" + this.reason + "\n location=" + this.location + "\n revision=" + this.revision + "\n wholeDocument=" + this.wholeDocument + "\n modified=" + this.modified + "\n certificationLevel=" + this.getCertificationLevel().name() + "\n signCertTrustedAndValid=" + this.signCertTrustedAndValid + "\n ocspPresent=" + this.ocspPresent + "\n ocspValid=" + this.ocspValid + "\n crlPresent=" + this.crlPresent + "\n ocspInCertPresent=" + this.ocspInCertPresent + "\n ocspInCertValid=" + this.ocspInCertValid + "\n timeStampTokenPresent=" + this.tsTokenPresent + "\n timeStampTokenValidationFail=" + (this.tsTokenValidationResult == null ? "no" : this.tsTokenValidationResult.getMessage()) + "\n fails=" + (this.fails == null ? "no" : Arrays.asList(this.fails)) + "\n certPath=" + (this.certPath == null ? "no" : this.certPath.getCertificates()) + "\n signingCertificate=" + (this.signingCertificate == null ? "no" : this.signingCertificate.toString()) + "\n]";
    }
}

