/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jsignpdf.BasicSignerOptions;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.PrivateKeyInfo;
import net.sf.jsignpdf.utils.ConfigProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStoreUtils {
    private static final Logger LOGGER = Logger.getLogger(KeyStoreUtils.class);

    public static SortedSet<String> getKeyStores() {
        Set<String> tmpKeyStores = Security.getAlgorithms("KeyStore");
        return new TreeSet<String>(tmpKeyStores);
    }

    public static String[] getKeyAliases(BasicSignerOptions options) {
        if (options == null) {
            throw new NullPointerException("Options are empty.");
        }
        LOGGER.info((Object)Constants.RES.get("console.getKeystoreType", options.getKsType()));
        KeyStore tmpKs = KeyStoreUtils.loadKeyStore(options.getKsType(), options.getKsFile(), options.getKsPasswd());
        if (tmpKs == null) {
            throw new NullPointerException(Constants.RES.get("error.keystoreNull"));
        }
        List<String> tmpResult = KeyStoreUtils.getAliasesList(tmpKs, options);
        return tmpResult.toArray(new String[tmpResult.size()]);
    }

    private static List<String> getAliasesList(KeyStore aKs, BasicSignerOptions options) {
        if (options == null) {
            throw new NullPointerException("Options are empty.");
        }
        if (aKs == null) {
            throw new NullPointerException(Constants.RES.get("error.keystoreNull"));
        }
        ArrayList<String> tmpResult = new ArrayList<String>();
        try {
            LOGGER.info((Object)Constants.RES.get("console.getAliases"));
            Enumeration<String> tmpAliases = aKs.aliases();
            boolean checkValidity = ConfigProvider.getInstance().getAsBool("certificate.checkValidity", true);
            boolean checkKeyUsage = ConfigProvider.getInstance().getAsBool("certificate.checkKeyUsage", true);
            boolean checkCriticalExtensions = ConfigProvider.getInstance().getAsBool("certificate.checkCriticalExtensions", true);
            while (tmpAliases.hasMoreElements()) {
                String tmpAlias = tmpAliases.nextElement();
                if (!aKs.isKeyEntry(tmpAlias)) continue;
                Certificate tmpCert = aKs.getCertificate(tmpAlias);
                boolean tmpAddAlias = true;
                if (tmpCert instanceof X509Certificate) {
                    Set<String> criticalExtensionOIDs;
                    boolean[] keyUsage;
                    X509Certificate tmpX509 = (X509Certificate)tmpCert;
                    if (checkValidity) {
                        try {
                            tmpX509.checkValidity();
                        }
                        catch (CertificateExpiredException e) {
                            LOGGER.info((Object)Constants.RES.get("console.certificateExpired", tmpAlias));
                            tmpAddAlias = false;
                        }
                        catch (CertificateNotYetValidException e) {
                            LOGGER.info((Object)Constants.RES.get("console.certificateNotYetValid", tmpAlias));
                            tmpAddAlias = false;
                        }
                    }
                    if (checkKeyUsage && (keyUsage = tmpX509.getKeyUsage()) != null && keyUsage.length > 0 && !keyUsage[0] && !keyUsage[1]) {
                        LOGGER.info((Object)Constants.RES.get("console.certificateNotForSignature", tmpAlias));
                        tmpAddAlias = false;
                    }
                    if (checkCriticalExtensions && (criticalExtensionOIDs = tmpX509.getCriticalExtensionOIDs()) != null) {
                        for (String oid : criticalExtensionOIDs) {
                            if (Constants.SUPPORTED_CRITICAL_EXTENSION_OIDS.contains(oid)) continue;
                            LOGGER.info((Object)Constants.RES.get("console.criticalExtensionNotSupported", tmpAlias, oid));
                            tmpAddAlias = false;
                        }
                    }
                }
                if (!tmpAddAlias) continue;
                tmpResult.add(tmpAlias);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)Constants.RES.get("console.exception"), (Throwable)e);
        }
        return tmpResult;
    }

    public static String getKeyAlias(BasicSignerOptions options) {
        KeyStore tmpKs = KeyStoreUtils.loadKeyStore(options.getKsType(), options.getKsFile(), options.getKsPasswd());
        String tmpResult = KeyStoreUtils.getKeyAliasInternal(options, tmpKs);
        return tmpResult;
    }

    private static String getKeyAliasInternal(BasicSignerOptions options, KeyStore aKs) {
        if (aKs == null) {
            String message = Constants.RES.get("error.keystoreNull");
            LOGGER.warn((Object)message);
            throw new NullPointerException(message);
        }
        String tmpResult = null;
        if (StringUtils.isNotEmpty((CharSequence)options.getKeyAliasX())) {
            try {
                if (aKs.isKeyEntry(options.getKeyAliasX())) {
                    tmpResult = options.getKeyAliasX();
                    LOGGER.info((Object)Constants.RES.get("console.usedKeyAlias", tmpResult));
                    return tmpResult;
                }
            }
            catch (KeyStoreException e) {
                // empty catch block
            }
        }
        List<String> tmpList = KeyStoreUtils.getAliasesList(aKs, options);
        String tmpAlias = options.getKeyAliasX();
        int tmpIndex = options.getKeyIndexX();
        if (tmpAlias != null && tmpList.contains(tmpAlias)) {
            tmpResult = tmpAlias;
        } else if (tmpList.size() > tmpIndex && tmpIndex >= 0) {
            tmpResult = tmpList.get(tmpIndex);
        } else if (tmpList.size() > 0) {
            tmpResult = tmpList.get(0);
        }
        LOGGER.info((Object)Constants.RES.get("console.usedKeyAlias", tmpResult));
        return tmpResult;
    }

    public static String[] getCertAliases(KeyStore tmpKs) {
        if (tmpKs == null) {
            return null;
        }
        ArrayList<String> tmpResult = new ArrayList<String>();
        try {
            Enumeration<String> tmpAliases = tmpKs.aliases();
            while (tmpAliases.hasMoreElements()) {
                String tmpAlias = tmpAliases.nextElement();
                if (!tmpKs.isCertificateEntry(tmpAlias)) continue;
                tmpResult.add(tmpAlias);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return tmpResult.toArray(new String[tmpResult.size()]);
    }

    public static String[] getCertAliases(String aKsType, String aKsFile, String aKsPasswd) {
        return KeyStoreUtils.getCertAliases(KeyStoreUtils.loadKeyStore(aKsType, aKsFile, aKsPasswd));
    }

    public static KeyStore loadKeyStore(String aKsType, String aKsFile, String aKsPasswd) {
        char[] tmpPass = null;
        if (aKsPasswd != null) {
            tmpPass = aKsPasswd.toCharArray();
        }
        return KeyStoreUtils.loadKeyStore(aKsType, aKsFile, tmpPass);
    }

    public static KeyStore createKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore newKeyStore = KeyStore.getInstance("JKS");
        newKeyStore.load(null, null);
        return newKeyStore;
    }

    public static boolean copyCertificates(KeyStore fromKeyStore, KeyStore toKeyStore) {
        if (fromKeyStore == null || toKeyStore == null) {
            return false;
        }
        try {
            for (String alias : KeyStoreUtils.getCertAliases(fromKeyStore)) {
                toKeyStore.setCertificateEntry(alias, fromKeyStore.getCertificate(alias));
            }
            return true;
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeyStore(String aKsType, String aKsFile, char[] aKsPasswd) {
        if (StringUtils.isEmpty((CharSequence)aKsType) && StringUtils.isEmpty((CharSequence)aKsFile)) {
            return KeyStoreUtils.loadCacertsKeyStore(null);
        }
        if (StringUtils.isEmpty((CharSequence)aKsType)) {
            aKsType = KeyStore.getDefaultType();
        }
        KeyStore tmpKs = null;
        InputStream tmpIS = null;
        try {
            tmpKs = KeyStore.getInstance(aKsType);
            if (StringUtils.isNotEmpty((CharSequence)aKsFile)) {
                tmpIS = new FileInputStream(aKsFile);
            }
            tmpKs.load(tmpIS, aKsPasswd);
            KeyStoreUtils.fixAliases(tmpKs);
        }
        catch (Exception e) {
            e.printStackTrace();
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (tmpIS != null) {
                try {
                    tmpIS.close();
                }
                catch (Exception e) {}
            }
        }
        return tmpKs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadCacertsKeyStore(String provider) {
        File file = new File(System.getProperty("java.home"), "lib");
        file = new File(file, "security");
        file = new File(file, "cacerts");
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            KeyStore k = provider == null ? KeyStore.getInstance("JKS") : KeyStore.getInstance("JKS", provider);
            k.load(fin, null);
            KeyStore keyStore = k;
            return keyStore;
        }
        catch (Exception e) {
            e.printStackTrace();
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public static PrivateKeyInfo getPkInfo(BasicSignerOptions options) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        KeyStore tmpKs = KeyStoreUtils.loadKeyStore(options.getKsType(), options.getKsFile(), options.getKsPasswd());
        String tmpAlias = KeyStoreUtils.getKeyAliasInternal(options, tmpKs);
        LOGGER.info((Object)Constants.RES.get("console.getPrivateKey"));
        PrivateKey tmpPk = (PrivateKey)tmpKs.getKey(tmpAlias, options.getKeyPasswdX());
        LOGGER.info((Object)Constants.RES.get("console.getCertChain"));
        Certificate[] tmpChain = tmpKs.getCertificateChain(tmpAlias);
        PrivateKeyInfo tmpResult = new PrivateKeyInfo(tmpPk, tmpChain);
        return tmpResult;
    }

    private static void fixAliases(KeyStore keyStore) {
        HashSet<String> tmpAliases = new HashSet<String>();
        try {
            Field field = keyStore.getClass().getDeclaredField("keyStoreSpi");
            field.setAccessible(true);
            KeyStoreSpi keyStoreVeritable = (KeyStoreSpi)field.get(keyStore);
            if ("sun.security.mscapi.KeyStore$MY".equals(keyStoreVeritable.getClass().getName())) {
                field = keyStoreVeritable.getClass().getEnclosingClass().getDeclaredField("entries");
                field.setAccessible(true);
                Collection entries = (Collection)field.get(keyStoreVeritable);
                for (Object entry : entries) {
                    String alias;
                    field = entry.getClass().getDeclaredField("certChain");
                    field.setAccessible(true);
                    X509Certificate[] certificates = (X509Certificate[])field.get(entry);
                    String hashCode = Integer.toString(certificates[0].hashCode());
                    field = entry.getClass().getDeclaredField("alias");
                    field.setAccessible(true);
                    String tmpAlias = alias = (String)field.get(entry);
                    int i = 0;
                    while (tmpAliases.contains(tmpAlias)) {
                        tmpAlias = alias + "-" + ++i;
                    }
                    tmpAliases.add(tmpAlias);
                    if (alias.equals(hashCode)) continue;
                    field.set(entry, tmpAlias);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

