/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.types;

import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import net.sf.jsignpdf.preview.FinalPropertyChangeSupport;
import net.sf.jsignpdf.types.FloatPoint;

public class RelRect {
    public static final String PROPERTY_START_POINT = "startPoint";
    public static final String PROPERTY_END_POINT = "endPoint";
    public int ERR = -1;
    private FloatPoint startPoint;
    private FloatPoint endPoint;
    private Dimension dimension = new Dimension(1, 1);
    private FinalPropertyChangeSupport pcs = new FinalPropertyChangeSupport(this);

    public boolean isValid() {
        return this.endPoint != null && this.startPoint != null;
    }

    public int getTop() {
        if (!this.isValid()) {
            return this.ERR;
        }
        return Math.round(this.getRelTop() * (float)this.dimension.height);
    }

    public int getBottom() {
        if (!this.isValid()) {
            return this.ERR;
        }
        return Math.round(this.getRelBottom() * (float)this.dimension.height);
    }

    public int getLeft() {
        if (!this.isValid()) {
            return this.ERR;
        }
        return Math.round(this.getRelLeft() * (float)this.dimension.width);
    }

    public int getRight() {
        if (!this.isValid()) {
            return this.ERR;
        }
        return Math.round(this.getRelRight() * (float)this.dimension.width);
    }

    public int getWidth() {
        if (!this.isValid()) {
            return this.ERR;
        }
        return Math.round(Math.abs(this.startPoint.x - this.endPoint.x) * (float)this.dimension.width);
    }

    public int getHeight() {
        if (!this.isValid()) {
            return this.ERR;
        }
        return Math.round(Math.abs(this.startPoint.y - this.endPoint.y) * (float)this.dimension.height);
    }

    public float getRelTop() {
        if (!this.isValid()) {
            return this.ERR;
        }
        return Math.min(this.startPoint.y, this.endPoint.y);
    }

    public float getRelBottom() {
        if (!this.isValid()) {
            return this.ERR;
        }
        return Math.max(this.startPoint.y, this.endPoint.y);
    }

    public float getRelLeft() {
        if (!this.isValid()) {
            return this.ERR;
        }
        return Math.min(this.startPoint.x, this.endPoint.x);
    }

    public float getRelRight() {
        if (!this.isValid()) {
            return this.ERR;
        }
        return Math.max(this.startPoint.x, this.endPoint.x);
    }

    public void setStartPoint(Point aPoint) {
        this.setStartPoint(this.getRelPoint(aPoint));
    }

    public void setStartPoint(FloatPoint aPoint) {
        FloatPoint oldPoint = this.startPoint;
        this.startPoint = aPoint;
        this.pcs.firePropertyChange(PROPERTY_START_POINT, oldPoint, this.startPoint);
    }

    public void setEndPoint(Point aPoint) {
        this.setEndPoint(this.getRelPoint(aPoint));
    }

    public void setEndPoint(FloatPoint aPoint) {
        FloatPoint oldPoint = this.endPoint;
        this.endPoint = aPoint;
        this.pcs.firePropertyChange(PROPERTY_END_POINT, oldPoint, this.endPoint);
    }

    public void scale(int newWidth, int newHeight) {
        if (newWidth < 1) {
            newWidth = 1;
        }
        if (newHeight < 1) {
            newHeight = 1;
        }
        this.dimension.setSize(newWidth, newHeight);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private FloatPoint getRelPoint(Point aPoint) {
        if (aPoint == null) {
            return null;
        }
        return new FloatPoint((float)aPoint.x / (float)this.dimension.width, (float)aPoint.y / (float)this.dimension.height);
    }

    public String toString() {
        return "RelRect [dimension=" + this.dimension + ", endPoint=" + this.endPoint + ", startPoint=" + this.startPoint + "]";
    }
}

