/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.preview;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import net.sf.jsignpdf.types.FloatPoint;
import net.sf.jsignpdf.types.RelRect;

public class SelectionImage
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BufferedImage image = null;
    private BufferedImage originalImage = null;
    private int offsetX;
    private int offsetY;
    private RelRect relRect = new RelRect();
    private Point currentPoint;

    public SelectionImage() {
        SelMouseAdapter tmpMouseAdapter = new SelMouseAdapter(1);
        this.addMouseListener(tmpMouseAdapter);
        this.addMouseMotionListener(tmpMouseAdapter);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                SelectionImage.this.createResizedImage();
            }
        });
    }

    public Point getCurrentPoint() {
        return this.currentPoint;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            g.drawImage(this.image, this.offsetX, this.offsetY, null);
            if (this.relRect.isValid()) {
                g.drawRect(this.relRect.getLeft() + this.offsetX, this.relRect.getTop() + this.offsetY, this.relRect.getWidth(), this.relRect.getHeight());
            }
        }
    }

    public void setImage(BufferedImage image) {
        this.originalImage = image;
        this.createResizedImage();
    }

    public BufferedImage getImage() {
        return this.originalImage;
    }

    public boolean isValidPosition() {
        return this.image != null && this.relRect != null;
    }

    private void createResizedImage() {
        if (this.originalImage == null) {
            this.image = null;
        } else {
            this.image = SelectionImage.resize(this.originalImage, this.getWidth(), this.getHeight());
            this.relRect.scale(this.image.getWidth(), this.image.getHeight());
            this.offsetX = (this.getWidth() - this.image.getWidth()) / 2;
            this.offsetY = (this.getHeight() - this.image.getHeight()) / 2;
        }
        this.repaint();
    }

    private static BufferedImage resize(BufferedImage aImg, int aWidth, int aHeight) {
        if (aWidth < 1) {
            aWidth = 1;
        }
        if (aHeight < 1) {
            aHeight = 1;
        }
        int w = aImg.getWidth();
        int h = aImg.getHeight();
        float rel = Math.min((float)aWidth / (float)w, (float)aHeight / (float)h);
        BufferedImage dimg = new BufferedImage(Math.round((float)w * rel), Math.round((float)h * rel), aImg.getType());
        Graphics2D g = dimg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(aImg, 0, 0, dimg.getWidth(), dimg.getHeight(), 0, 0, w, h, null);
        g.dispose();
        return dimg;
    }

    public RelRect getRelRect() {
        return this.relRect;
    }

    class SelMouseAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        private int btnCode;
        private boolean btnPressed = false;

        public SelMouseAdapter(int aBtnCode) {
            this.btnCode = aBtnCode;
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() != this.btnCode) {
                return;
            }
            this.btnPressed = true;
            Point point = e.getPoint();
            SelectionImage.this.relRect.setStartPoint(new Point(point.x - SelectionImage.this.offsetX, point.y - SelectionImage.this.offsetY));
            SelectionImage.this.relRect.setEndPoint((FloatPoint)null);
            SelectionImage.this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            SelectionImage.this.currentPoint = e.getPoint();
            if (!this.btnPressed) {
                return;
            }
            Point point = e.getPoint();
            SelectionImage.this.relRect.setEndPoint(new Point(point.x - SelectionImage.this.offsetX, point.y - SelectionImage.this.offsetY));
            SelectionImage.this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
            SelectionImage.this.currentPoint = e.getPoint();
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getButton() != this.btnCode || !this.btnPressed) {
                return;
            }
            this.btnPressed = false;
            Point point = e.getPoint();
            SelectionImage.this.relRect.setEndPoint(new Point(point.x - SelectionImage.this.offsetX, point.y - SelectionImage.this.offsetY));
            SelectionImage.this.repaint();
        }
    }
}

