/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.preview;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.decrypt.PDFPassword;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.sf.jsignpdf.BasicSignerOptions;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

public class Pdf2Image {
    private BasicSignerOptions options;

    public Pdf2Image(BasicSignerOptions anOpts) {
        if (anOpts == null) {
            throw new NullPointerException("Options have to be not-null");
        }
        this.options = anOpts;
    }

    public BufferedImage getImageForPage(int aPage) {
        BufferedImage tmpResult = this.getImageUsingPdfRenderer(aPage);
        if (tmpResult == null) {
            tmpResult = this.getImageUsingPdfBox(aPage);
        }
        return tmpResult;
    }

    public BufferedImage getImageUsingPdfRenderer(int aPage) {
        BufferedImage tmpResult = null;
        try {
            File file = new File(this.options.getInFile());
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            FileChannel channel = raf.getChannel();
            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            PDFFile pdffile = null;
            try {
                pdffile = new PDFFile(buf);
            }
            catch (PDFParseException ppe) {
                try {
                    pdffile = new PDFFile(buf, new PDFPassword(""));
                }
                catch (PDFParseException ppe2) {
                    pdffile = new PDFFile(buf, new PDFPassword(this.options.getPdfOwnerPwdStr()));
                }
            }
            PDFPage page = pdffile.getPage(aPage);
            Rectangle rect = new Rectangle(0, 0, (int)page.getBBox().getWidth(), (int)page.getBBox().getHeight());
            tmpResult = (BufferedImage)page.getImage(rect.width, rect.height, rect, null, true, true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tmpResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImageUsingPdfBox(int aPage) {
        BufferedImage tmpResult = null;
        PDDocument tmpDoc = null;
        try {
            int resolution;
            tmpDoc = PDDocument.load((String)this.options.getInFile());
            if (tmpDoc.isEncrypted()) {
                tmpDoc.decrypt(this.options.getPdfOwnerPwdStr());
            }
            try {
                resolution = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (HeadlessException e) {
                resolution = 96;
            }
            PDPage page = (PDPage)tmpDoc.getDocumentCatalog().getAllPages().get(aPage - 1);
            tmpResult = page.convertToImage(1, resolution);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (tmpDoc != null) {
                try {
                    tmpDoc.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return tmpResult;
    }
}

