/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf;

import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.OcspClientBouncyCastle;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSignature;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.TSAClientBouncyCastle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import net.sf.jsignpdf.BasicSignerOptions;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.crl.CRLInfo;
import net.sf.jsignpdf.types.RenderMode;
import net.sf.jsignpdf.utils.FontUtils;
import net.sf.jsignpdf.utils.KeyStoreUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SignerLogic
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(SignerLogic.class);
    private final BasicSignerOptions options;

    public SignerLogic(BasicSignerOptions anOptions) {
        if (anOptions == null) {
            throw new NullPointerException("Options has to be filled.");
        }
        this.options = anOptions;
    }

    public void run() {
        this.signFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean signFile() {
        block57: {
            block55: {
                block53: {
                    block54: {
                        block51: {
                            block52: {
                                outFile = this.options.getOutFileX();
                                if (!this.validateInOutFiles(this.options.getInFile(), outFile)) {
                                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.skippingSigning"));
                                    return false;
                                }
                                finished = false;
                                tmpException = null;
                                fout = null;
                                pkInfo = KeyStoreUtils.getPkInfo(this.options);
                                key = pkInfo.getKey();
                                chain = pkInfo.getChain();
                                if (!ArrayUtils.isEmpty((Object[])chain)) break block51;
                                SignerLogic.LOGGER.info((Object)Constants.RES.get("console.certificateChainEmpty"));
                                var8_13 = false;
                                if (fout == null) break block52;
                                try {
                                    fout.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            SignerLogic.LOGGER.info((Object)Constants.RES.get("console.finished." + (finished != false ? "ok" : "error")));
                            this.options.fireSignerFinishedEvent(tmpException);
                            return var8_13;
                        }
                        SignerLogic.LOGGER.info((Object)Constants.RES.get("console.createPdfReader", new String[]{this.options.getInFile()}));
                        try {
                            reader = new PdfReader(this.options.getInFile());
                        }
                        catch (Exception e) {
                            try {
                                reader = new PdfReader(this.options.getInFile(), new byte[0]);
                            }
                            catch (Exception e2) {
                                reader = new PdfReader(this.options.getInFile(), this.options.getPdfOwnerPwdStr().getBytes());
                            }
                        }
                        SignerLogic.LOGGER.info((Object)Constants.RES.get("console.createOutPdf", new String[]{outFile}));
                        fout = new FileOutputStream(outFile);
                        hashAlgorithm = this.options.getHashAlgorithmX();
                        SignerLogic.LOGGER.info((Object)Constants.RES.get("console.createSignature"));
                        tmpPdfVersion = '\u0000';
                        if (reader.getPdfVersion() >= hashAlgorithm.getPdfVersion()) ** GOTO lbl60
                        if (!this.options.isAppendX()) break block53;
                        SignerLogic.LOGGER.info((Object)Constants.RES.get("console.updateVersionNotPossibleInAppendMode"));
                        var11_20 = false;
                        if (fout == null) break block54;
                        try {
                            fout.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.finished." + (finished != false ? "ok" : "error")));
                    this.options.fireSignerFinishedEvent(tmpException);
                    return var11_20;
                }
                tmpPdfVersion = hashAlgorithm.getPdfVersion();
                SignerLogic.LOGGER.info((Object)Constants.RES.get("console.updateVersion", new String[]{String.valueOf(reader.getPdfVersion()), String.valueOf(tmpPdfVersion)}));
lbl60:
                // 2 sources

                stp = PdfStamper.createSignature((PdfReader)reader, (OutputStream)fout, (char)tmpPdfVersion, null, (boolean)this.options.isAppendX());
                if (!this.options.isAppendX()) {
                    acroFields = stp.getAcroFields();
                    sigNames = acroFields.getSignatureNames();
                    for (String sigName : sigNames) {
                        acroFields.removeField(sigName);
                    }
                }
                if (this.options.isEncryptedX()) {
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.setEncryption"));
                    tmpRight = this.options.getRightPrinting().getRight() | (this.options.isRightCopy() != false ? 16 : 0) | (this.options.isRightAssembly() != false ? 1024 : 0) | (this.options.isRightFillIn() != false ? 256 : 0) | (this.options.isRightScreanReaders() != false ? 512 : 0) | (this.options.isRightModifyAnnotations() != false ? 32 : 0) | (this.options.isRightModifyContents() != false ? 8 : 0);
                    stp.setEncryption(true, this.options.getPdfUserPwdStr(), this.options.getPdfOwnerPwdStr(), tmpRight);
                }
                sap = stp.getSignatureAppearance();
                sap.setCrypto(key, (Certificate[])chain, null, PdfSignatureAppearance.WINCER_SIGNED);
                if (StringUtils.isNotEmpty((CharSequence)this.options.getReason())) {
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.setReason", new String[]{this.options.getReason()}));
                    sap.setReason(this.options.getReason());
                }
                if (StringUtils.isNotEmpty((CharSequence)this.options.getLocation())) {
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.setLocation", new String[]{this.options.getLocation()}));
                    sap.setLocation(this.options.getLocation());
                }
                if (StringUtils.isNotEmpty((CharSequence)this.options.getContact())) {
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.setContact", new String[]{this.options.getContact()}));
                    sap.setContact(this.options.getContact());
                }
                SignerLogic.LOGGER.info((Object)Constants.RES.get("console.setCertificationLevel"));
                sap.setCertificationLevel(this.options.getCertLevelX().getLevel());
                if (this.options.isVisible()) {
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.configureVisible"));
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.setAcro6Layers", new String[]{Boolean.toString(this.options.isAcro6Layers())}));
                    sap.setAcro6Layers(this.options.isAcro6Layers());
                    tmpImgPath = this.options.getImgPath();
                    if (tmpImgPath != null) {
                        SignerLogic.LOGGER.info((Object)Constants.RES.get("console.createImage", new String[]{tmpImgPath}));
                        img = Image.getInstance((String)tmpImgPath);
                        SignerLogic.LOGGER.info((Object)Constants.RES.get("console.setSignatureGraphic"));
                        sap.setSignatureGraphic(img);
                    }
                    if ((tmpBgImgPath = this.options.getBgImgPath()) != null) {
                        SignerLogic.LOGGER.info((Object)Constants.RES.get("console.createImage", new String[]{tmpBgImgPath}));
                        img = Image.getInstance((String)tmpBgImgPath);
                        SignerLogic.LOGGER.info((Object)Constants.RES.get("console.setImage"));
                        sap.setImage(img);
                    }
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.setImageScale"));
                    sap.setImageScale(this.options.getBgImgScale());
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.setL2Text"));
                    if (this.options.getL2Text() != null) {
                        sap.setLayer2Text(this.options.getL2Text());
                    } else {
                        buf = new StringBuilder();
                        buf.append(Constants.RES.get("default.l2text.signedBy")).append(" ");
                        buf.append(PdfPKCS7.getSubjectFields((X509Certificate)((X509Certificate)chain[0])).getField("CN")).append('\n');
                        sd = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
                        buf.append(Constants.RES.get("default.l2text.date")).append(" ").append(sd.format(sap.getSignDate().getTime()));
                        if (StringUtils.isNotEmpty((CharSequence)this.options.getReason())) {
                            buf.append('\n').append(Constants.RES.get("default.l2text.reason")).append(" ").append(this.options.getReason());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)this.options.getLocation())) {
                            buf.append('\n').append(Constants.RES.get("default.l2text.location")).append(" ").append(this.options.getLocation());
                        }
                        sap.setLayer2Text(buf.toString());
                    }
                    if (FontUtils.getL2BaseFont() != null) {
                        sap.setLayer2Font(new Font(FontUtils.getL2BaseFont(), this.options.getL2TextFontSize()));
                    }
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.setL4Text"));
                    sap.setLayer4Text(this.options.getL4Text());
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.setRender"));
                    renderMode = this.options.getRenderMode();
                    if (renderMode == RenderMode.GRAPHIC_AND_DESCRIPTION && sap.getSignatureGraphic() == null) {
                        SignerLogic.LOGGER.warn((Object)"Render mode of visible signature is set to GRAPHIC_AND_DESCRIPTION, but no image is loaded. Fallback to DESCRIPTION_ONLY.");
                        SignerLogic.LOGGER.info((Object)Constants.RES.get("console.renderModeFallback"));
                        renderMode = RenderMode.DESCRIPTION_ONLY;
                    }
                    sap.setRender(renderMode.getRender());
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.setVisibleSignature"));
                    sap.setVisibleSignature(new Rectangle(this.options.getPositionLLX(), this.options.getPositionLLY(), this.options.getPositionURX(), this.options.getPositionURY()), this.options.getPage(), null);
                }
                SignerLogic.LOGGER.info((Object)Constants.RES.get("console.processing"));
                dic = new PdfSignature(PdfName.ADOBE_PPKLITE, new PdfName("adbe.pkcs7.detached"));
                if (!StringUtils.isEmpty((CharSequence)this.options.getReason())) {
                    dic.setReason(sap.getReason());
                }
                if (!StringUtils.isEmpty((CharSequence)this.options.getLocation())) {
                    dic.setLocation(sap.getLocation());
                }
                if (!StringUtils.isEmpty((CharSequence)this.options.getContact())) {
                    dic.setContact(sap.getContact());
                }
                dic.setDate(new PdfDate(sap.getSignDate()));
                sap.setCryptoDictionary((PdfDictionary)dic);
                tmpProxy = this.options.createProxy();
                crlInfo = new CRLInfo(this.options, (Certificate[])chain);
                contentEstimated = (int)(15000L + 2L * crlInfo.getByteCount());
                exc = new HashMap<PdfName, Integer>();
                exc.put(PdfName.CONTENTS, new Integer(contentEstimated * 2 + 2));
                sap.preClose(exc);
                sgn = new PdfPKCS7(key, (Certificate[])chain, crlInfo.getCrls(), hashAlgorithm.getAlgorithmName(), null, false);
                data = sap.getRangeStream();
                messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithmName());
                buf = new byte[8192];
                while ((n = data.read(buf)) > 0) {
                    messageDigest.update(buf, 0, n);
                }
                hash = messageDigest.digest();
                cal = Calendar.getInstance();
                ocsp = null;
                if (this.options.isOcspEnabledX() && chain.length >= 2) {
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.getOCSPURL"));
                    url = PdfPKCS7.getOCSPURL((X509Certificate)((X509Certificate)chain[0]));
                    if (StringUtils.isEmpty((CharSequence)url)) {
                        SignerLogic.LOGGER.info((Object)Constants.RES.get("console.noOCSPURL"));
                        url = this.options.getOcspServerUrl();
                    }
                    if (!StringUtils.isEmpty((CharSequence)url)) {
                        SignerLogic.LOGGER.info((Object)Constants.RES.get("console.readingOCSP", new String[]{url}));
                        ocspClient = new OcspClientBouncyCastle((X509Certificate)chain[0], (X509Certificate)chain[1], url);
                        ocspClient.setProxy(tmpProxy);
                        ocsp = ocspClient.getEncoded();
                    }
                }
                sh = sgn.getAuthenticatedAttributeBytes(hash, cal, ocsp);
                sgn.update(sh, 0, sh.length);
                tsc = null;
                if (this.options.isTimestampX() && !StringUtils.isEmpty((CharSequence)this.options.getTsaUrl())) {
                    SignerLogic.LOGGER.info((Object)Constants.RES.get("console.creatingTsaClient"));
                    tsc = new TSAClientBouncyCastle(this.options.getTsaUrl(), StringUtils.defaultString((String)this.options.getTsaUser()), StringUtils.defaultString((String)this.options.getTsaPasswd()));
                    tsc.setProxy(tmpProxy);
                    policyOid = this.options.getTsaPolicy();
                    if (StringUtils.isNotEmpty((CharSequence)policyOid)) {
                        SignerLogic.LOGGER.info((Object)Constants.RES.get("console.settingTsaPolicy", new String[]{policyOid}));
                        tsc.setPolicy(policyOid);
                    }
                }
                if (contentEstimated + 2 < (encodedSig = sgn.getEncodedPKCS7(hash, cal, tsc, ocsp)).length) {
                    System.err.println("SigSize - contentEstimated=" + contentEstimated + ", sigLen=" + encodedSig.length);
                    throw new Exception("Not enough space");
                }
                paddedSig = new byte[contentEstimated];
                System.arraycopy(encodedSig, 0, paddedSig, 0, encodedSig.length);
                dic2 = new PdfDictionary();
                dic2.put(PdfName.CONTENTS, (PdfObject)new PdfString(paddedSig).setHexWriting(true));
                SignerLogic.LOGGER.info((Object)Constants.RES.get("console.closeStream"));
                sap.close(dic2);
                fout.close();
                fout = null;
                finished = true;
                if (fout == null) break block55;
                try {
                    fout.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            SignerLogic.LOGGER.info((Object)Constants.RES.get("console.finished." + (finished != false ? "ok" : "error")));
            this.options.fireSignerFinishedEvent(tmpException);
            break block57;
            catch (Exception e) {
                block56: {
                    SignerLogic.LOGGER.error((Object)Constants.RES.get("console.exception"), (Throwable)e);
                    if (fout == null) break block56;
                    try {
                        fout.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                SignerLogic.LOGGER.info((Object)Constants.RES.get("console.finished." + (finished != false ? "ok" : "error")));
                this.options.fireSignerFinishedEvent(tmpException);
                break block57;
            }
            catch (OutOfMemoryError e) {
                block58: {
                    SignerLogic.LOGGER.fatal((Object)Constants.RES.get("console.memoryError"), (Throwable)e);
                    if (fout == null) break block58;
                    {
                        catch (Throwable var31_45) {
                            if (fout != null) {
                                try {
                                    fout.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            SignerLogic.LOGGER.info((Object)Constants.RES.get("console.finished." + (finished != false ? "ok" : "error")));
                            this.options.fireSignerFinishedEvent(tmpException);
                            throw var31_45;
                        }
                    }
                    try {
                        fout.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                SignerLogic.LOGGER.info((Object)Constants.RES.get("console.finished." + (finished != false ? "ok" : "error")));
                this.options.fireSignerFinishedEvent(tmpException);
            }
        }
        return finished;
    }

    private boolean validateInOutFiles(String inFile, String outFile) {
        LOGGER.info((Object)Constants.RES.get("console.validatingFiles"));
        if (StringUtils.isEmpty((CharSequence)inFile) || StringUtils.isEmpty((CharSequence)outFile)) {
            LOGGER.info((Object)Constants.RES.get("console.fileNotFilled.error"));
            return false;
        }
        File tmpInFile = new File(inFile);
        File tmpOutFile = new File(outFile);
        if (!(tmpInFile.exists() && tmpInFile.isFile() && tmpInFile.canRead())) {
            LOGGER.info((Object)Constants.RES.get("console.inFileNotFound.error"));
            return false;
        }
        if (tmpInFile.getAbsolutePath().equals(tmpOutFile.getAbsolutePath())) {
            LOGGER.info((Object)Constants.RES.get("console.filesAreEqual.error"));
            return false;
        }
        return true;
    }
}

