/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf;

import javax.swing.JTextArea;
import net.sf.jsignpdf.Constants;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class JTextAreaAppender
extends AppenderSkeleton {
    private JTextArea jTextArea;

    public JTextAreaAppender(JTextArea jTextArea) {
        if (jTextArea == null) {
            throw new IllegalArgumentException("JTextArea has to be not-null.");
        }
        this.jTextArea = jTextArea;
    }

    public void close() {
        this.jTextArea = null;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void append(LoggingEvent event) {
        if (this.layout == null) {
            this.errorHandler.error("No layout for appender " + this.name, null, 5);
            return;
        }
        String message = this.layout.format(event);
        this.jTextArea.append(message);
        if (this.layout.ignoresThrowable()) {
            for (String throwableRow : ArrayUtils.nullToEmpty((String[])event.getThrowableStrRep())) {
                this.jTextArea.append(throwableRow + Constants.NEW_LINE);
            }
        }
        this.jTextArea.setCaretPosition(this.jTextArea.getText().length());
    }
}

