/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUCache;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.LocaleUtility;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.locale.AsciiUtil;
import com.ibm.icu.impl.locale.BaseLocale;
import com.ibm.icu.impl.locale.InternalLocaleBuilder;
import com.ibm.icu.impl.locale.LanguageTag;
import com.ibm.icu.impl.locale.LocaleExtensions;
import com.ibm.icu.impl.locale.LocaleSyntaxException;
import com.ibm.icu.util.IllformedLocaleException;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.VersionInfo;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;

public final class ULocale
implements Serializable {
    private static final long serialVersionUID = 3715177670352309217L;
    public static final ULocale ENGLISH = new ULocale("en", Locale.ENGLISH);
    public static final ULocale FRENCH = new ULocale("fr", Locale.FRENCH);
    public static final ULocale GERMAN = new ULocale("de", Locale.GERMAN);
    public static final ULocale ITALIAN = new ULocale("it", Locale.ITALIAN);
    public static final ULocale JAPANESE = new ULocale("ja", Locale.JAPANESE);
    public static final ULocale KOREAN = new ULocale("ko", Locale.KOREAN);
    public static final ULocale CHINESE = new ULocale("zh", Locale.CHINESE);
    public static final ULocale SIMPLIFIED_CHINESE = new ULocale("zh_Hans", Locale.CHINESE);
    public static final ULocale TRADITIONAL_CHINESE = new ULocale("zh_Hant", Locale.CHINESE);
    public static final ULocale FRANCE = new ULocale("fr_FR", Locale.FRANCE);
    public static final ULocale GERMANY = new ULocale("de_DE", Locale.GERMANY);
    public static final ULocale ITALY = new ULocale("it_IT", Locale.ITALY);
    public static final ULocale JAPAN = new ULocale("ja_JP", Locale.JAPAN);
    public static final ULocale KOREA = new ULocale("ko_KR", Locale.KOREA);
    public static final ULocale CHINA;
    public static final ULocale PRC;
    public static final ULocale TAIWAN;
    public static final ULocale UK;
    public static final ULocale US;
    public static final ULocale CANADA;
    public static final ULocale CANADA_FRENCH;
    private static final String EMPTY_STRING = "";
    private static final char UNDERSCORE = '_';
    private static final Locale EMPTY_LOCALE;
    public static final ULocale ROOT;
    private static final SimpleCache CACHE;
    private transient Locale locale;
    private String localeID;
    private static String[] _languages;
    private static String[] _replacementLanguages;
    private static String[] _obsoleteLanguages;
    private static String[] _languages3;
    private static String[] _obsoleteLanguages3;
    private static String[] _countries;
    private static String[] _deprecatedCountries;
    private static String[] _replacementCountries;
    private static String[] _obsoleteCountries;
    private static String[] _countries3;
    private static String[] _obsoleteCountries3;
    private static String[][] CANONICALIZE_MAP;
    private static String[][] variantsToKeywords;
    private static final String[][] _javaLocaleMap;
    private static ICUCache nameCache;
    private static Locale defaultLocale;
    private static ULocale defaultULocale;
    private static VersionInfo gCLDRVersion;
    public static Type ACTUAL_LOCALE;
    public static Type VALID_LOCALE;
    private static final String UNDEFINED_LANGUAGE = "und";
    private static final String UNDEFINED_SCRIPT = "Zzzz";
    private static final String UNDEFINED_REGION = "ZZ";
    public static final char PRIVATE_USE_EXTENSION = 'x';
    public static final char LDML_EXTENSION = 'u';
    static /* synthetic */ Class class$com$ibm$icu$util$ULocale;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLanguageTables() {
        if (_languages == null) {
            String[] tempLanguages = new String[]{"aa", "ab", "ace", "ach", "ada", "ady", "ae", "af", "afa", "afh", "ak", "akk", "ale", "alg", "am", "an", "ang", "apa", "ar", "arc", "arn", "arp", "art", "arw", "as", "ast", "ath", "aus", "av", "awa", "ay", "az", "ba", "bad", "bai", "bal", "ban", "bas", "bat", "be", "bej", "bem", "ber", "bg", "bh", "bho", "bi", "bik", "bin", "bla", "bm", "bn", "bnt", "bo", "br", "bra", "bs", "btk", "bua", "bug", "byn", "ca", "cad", "cai", "car", "cau", "ce", "ceb", "cel", "ch", "chb", "chg", "chk", "chm", "chn", "cho", "chp", "chr", "chy", "cmc", "co", "cop", "cpe", "cpf", "cpp", "cr", "crh", "crp", "cs", "csb", "cu", "cus", "cv", "cy", "da", "dak", "dar", "day", "de", "del", "den", "dgr", "din", "doi", "dra", "dsb", "dua", "dum", "dv", "dyu", "dz", "ee", "efi", "egy", "eka", "el", "elx", "en", "enm", "eo", "es", "et", "eu", "ewo", "fa", "fan", "fat", "ff", "fi", "fiu", "fj", "fo", "fon", "fr", "frm", "fro", "fur", "fy", "ga", "gaa", "gay", "gba", "gd", "gem", "gez", "gil", "gl", "gmh", "gn", "goh", "gon", "gor", "got", "grb", "grc", "gu", "gv", "gwi", "ha", "hai", "haw", "he", "hi", "hil", "him", "hit", "hmn", "ho", "hr", "hsb", "ht", "hu", "hup", "hy", "hz", "ia", "iba", "id", "ie", "ig", "ii", "ijo", "ik", "ilo", "inc", "ine", "inh", "io", "ira", "iro", "is", "it", "iu", "ja", "jbo", "jpr", "jrb", "jv", "ka", "kaa", "kab", "kac", "kam", "kar", "kaw", "kbd", "kg", "kha", "khi", "kho", "ki", "kj", "kk", "kl", "km", "kmb", "kn", "ko", "kok", "kos", "kpe", "kr", "krc", "kro", "kru", "ks", "ku", "kum", "kut", "kv", "kw", "ky", "la", "lad", "lah", "lam", "lb", "lez", "lg", "li", "ln", "lo", "lol", "loz", "lt", "lu", "lua", "lui", "lun", "luo", "lus", "lv", "mad", "mag", "mai", "mak", "man", "map", "mas", "mdf", "mdr", "men", "mg", "mga", "mh", "mi", "mic", "min", "mis", "mk", "mkh", "ml", "mn", "mnc", "mni", "mno", "mo", "moh", "mos", "mr", "ms", "mt", "mul", "mun", "mus", "mwr", "my", "myn", "myv", "na", "nah", "nai", "nap", "nb", "nd", "nds", "ne", "new", "ng", "nia", "nic", "niu", "nl", "nn", "no", "nog", "non", "nr", "nso", "nub", "nv", "nwc", "ny", "nym", "nyn", "nyo", "nzi", "oc", "oj", "om", "or", "os", "osa", "ota", "oto", "pa", "paa", "pag", "pal", "pam", "pap", "pau", "peo", "phi", "phn", "pi", "pl", "pon", "pra", "pro", "ps", "pt", "qu", "raj", "rap", "rar", "rm", "rn", "ro", "roa", "rom", "ru", "rup", "rw", "sa", "sad", "sah", "sai", "sal", "sam", "sas", "sat", "sc", "sco", "sd", "se", "sel", "sem", "sg", "sga", "sgn", "shn", "si", "sid", "sio", "sit", "sk", "sl", "sla", "sm", "sma", "smi", "smj", "smn", "sms", "sn", "snk", "so", "sog", "son", "sq", "sr", "srr", "ss", "ssa", "st", "su", "suk", "sus", "sux", "sv", "sw", "syr", "ta", "tai", "te", "tem", "ter", "tet", "tg", "th", "ti", "tig", "tiv", "tk", "tkl", "tl", "tlh", "tli", "tmh", "tn", "to", "tog", "tpi", "tr", "ts", "tsi", "tt", "tum", "tup", "tut", "tvl", "tw", "ty", "tyv", "udm", "ug", "uga", "uk", "umb", UNDEFINED_LANGUAGE, "ur", "uz", "vai", "ve", "vi", "vo", "vot", "wa", "wak", "wal", "war", "was", "wen", "wo", "xal", "xh", "yao", "yap", "yi", "yo", "ypk", "za", "zap", "zen", "zh", "znd", "zu", "zun"};
            String[] tempReplacementLanguages = new String[]{"id", "he", "yi", "jv", "sr", "nb"};
            String[] tempObsoleteLanguages = new String[]{"in", "iw", "ji", "jw", "sh", "no"};
            String[] tempLanguages3 = new String[]{"aar", "abk", "ace", "ach", "ada", "ady", "ave", "afr", "afa", "afh", "aka", "akk", "ale", "alg", "amh", "arg", "ang", "apa", "ara", "arc", "arn", "arp", "art", "arw", "asm", "ast", "ath", "aus", "ava", "awa", "aym", "aze", "bak", "bad", "bai", "bal", "ban", "bas", "bat", "bel", "bej", "bem", "ber", "bul", "bih", "bho", "bis", "bik", "bin", "bla", "bam", "ben", "bnt", "bod", "bre", "bra", "bos", "btk", "bua", "bug", "byn", "cat", "cad", "cai", "car", "cau", "che", "ceb", "cel", "cha", "chb", "chg", "chk", "chm", "chn", "cho", "chp", "chr", "chy", "cmc", "cos", "cop", "cpe", "cpf", "cpp", "cre", "crh", "crp", "ces", "csb", "chu", "cus", "chv", "cym", "dan", "dak", "dar", "day", "deu", "del", "den", "dgr", "din", "doi", "dra", "dsb", "dua", "dum", "div", "dyu", "dzo", "ewe", "efi", "egy", "eka", "ell", "elx", "eng", "enm", "epo", "spa", "est", "eus", "ewo", "fas", "fan", "fat", "ful", "fin", "fiu", "fij", "fao", "fon", "fra", "frm", "fro", "fur", "fry", "gle", "gaa", "gay", "gba", "gla", "gem", "gez", "gil", "glg", "gmh", "grn", "goh", "gon", "gor", "got", "grb", "grc", "guj", "glv", "gwi", "hau", "hai", "haw", "heb", "hin", "hil", "him", "hit", "hmn", "hmo", "hrv", "hsb", "hat", "hun", "hup", "hye", "her", "ina", "iba", "ind", "ile", "ibo", "iii", "ijo", "ipk", "ilo", "inc", "ine", "inh", "ido", "ira", "iro", "isl", "ita", "iku", "jpn", "jbo", "jpr", "jrb", "jaw", "kat", "kaa", "kab", "kac", "kam", "kar", "kaw", "kbd", "kon", "kha", "khi", "kho", "kik", "kua", "kaz", "kal", "khm", "kmb", "kan", "kor", "kok", "kos", "kpe", "kau", "krc", "kro", "kru", "kas", "kur", "kum", "kut", "kom", "cor", "kir", "lat", "lad", "lah", "lam", "ltz", "lez", "lug", "lim", "lin", "lao", "lol", "loz", "lit", "lub", "lua", "lui", "lun", "luo", "lus", "lav", "mad", "mag", "mai", "mak", "man", "map", "mas", "mdf", "mdr", "men", "mlg", "mga", "mah", "mri", "mic", "min", "mis", "mkd", "mkh", "mal", "mon", "mnc", "mni", "mno", "mol", "moh", "mos", "mar", "msa", "mlt", "mul", "mun", "mus", "mwr", "mya", "myn", "myv", "nau", "nah", "nai", "nap", "nob", "nde", "nds", "nep", "new", "ndo", "nia", "nic", "niu", "nld", "nno", "nor", "nog", "non", "nbl", "nso", "nub", "nav", "nwc", "nya", "nym", "nyn", "nyo", "nzi", "oci", "oji", "orm", "ori", "oss", "osa", "ota", "oto", "pan", "paa", "pag", "pal", "pam", "pap", "pau", "peo", "phi", "phn", "pli", "pol", "pon", "pra", "pro", "pus", "por", "que", "raj", "rap", "rar", "roh", "run", "ron", "roa", "rom", "rus", "rup", "kin", "san", "sad", "sah", "sai", "sal", "sam", "sas", "sat", "srd", "sco", "snd", "sme", "sel", "sem", "sag", "sga", "sgn", "shn", "sin", "sid", "sio", "sit", "slk", "slv", "sla", "smo", "sma", "smi", "smj", "smn", "sms", "sna", "snk", "som", "sog", "son", "sqi", "srp", "srr", "ssw", "ssa", "sot", "sun", "suk", "sus", "sux", "swe", "swa", "syr", "tam", "tai", "tel", "tem", "ter", "tet", "tgk", "tha", "tir", "tig", "tiv", "tuk", "tkl", "tgl", "tlh", "tli", "tmh", "tsn", "ton", "tog", "tpi", "tur", "tso", "tsi", "tat", "tum", "tup", "tut", "tvl", "twi", "tah", "tyv", "udm", "uig", "uga", "ukr", "umb", UNDEFINED_LANGUAGE, "urd", "uzb", "vai", "ven", "vie", "vol", "vot", "wln", "wak", "wal", "war", "was", "wen", "wol", "xal", "xho", "yao", "yap", "yid", "yor", "ypk", "zha", "zap", "zen", "zho", "znd", "zul", "zun"};
            String[] tempObsoleteLanguages3 = new String[]{"ind", "heb", "yid", "jaw", "srp"};
            Class clazz = class$com$ibm$icu$util$ULocale == null ? (class$com$ibm$icu$util$ULocale = ULocale.class$("com.ibm.icu.util.ULocale")) : class$com$ibm$icu$util$ULocale;
            synchronized (clazz) {
                if (_languages == null) {
                    _languages = tempLanguages;
                    _replacementLanguages = tempReplacementLanguages;
                    _obsoleteLanguages = tempObsoleteLanguages;
                    _languages3 = tempLanguages3;
                    _obsoleteLanguages3 = tempObsoleteLanguages3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initCountryTables() {
        if (_countries == null) {
            String[] tempCountries = new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IR", "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MF", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "ZA", "ZM", "ZW"};
            String[] tempObsoleteCountries = new String[]{"FX", "CS", "RO", "TP", "YU", "ZR"};
            String[] tempDeprecatedCountries = new String[]{"BU", "CS", "DY", "FX", "HV", "NH", "RH", "TP", "YU", "ZR"};
            String[] tempReplacementCountries = new String[]{"MM", "RS", "BJ", "FR", "BF", "VU", "ZW", "TL", "RS", "CD"};
            String[] tempCountries3 = new String[]{"AND", "ARE", "AFG", "ATG", "AIA", "ALB", "ARM", "ANT", "AGO", "ATA", "ARG", "ASM", "AUT", "AUS", "ABW", "ALA", "AZE", "BIH", "BRB", "BGD", "BEL", "BFA", "BGR", "BHR", "BDI", "BEN", "BLM", "BMU", "BRN", "BOL", "BRA", "BHS", "BTN", "BVT", "BWA", "BLR", "BLZ", "CAN", "CCK", "COD", "CAF", "COG", "CHE", "CIV", "COK", "CHL", "CMR", "CHN", "COL", "CRI", "CUB", "CPV", "CXR", "CYP", "CZE", "DEU", "DJI", "DNK", "DMA", "DOM", "DZA", "ECU", "EST", "EGY", "ESH", "ERI", "ESP", "ETH", "FIN", "FJI", "FLK", "FSM", "FRO", "FRA", "GAB", "GBR", "GRD", "GEO", "GUF", "GGY", "GHA", "GIB", "GRL", "GMB", "GIN", "GLP", "GNQ", "GRC", "SGS", "GTM", "GUM", "GNB", "GUY", "HKG", "HMD", "HND", "HRV", "HTI", "HUN", "IDN", "IRL", "ISR", "IMN", "IND", "IOT", "IRQ", "IRN", "ISL", "ITA", "JEY", "JAM", "JOR", "JPN", "KEN", "KGZ", "KHM", "KIR", "COM", "KNA", "PRK", "KOR", "KWT", "CYM", "KAZ", "LAO", "LBN", "LCA", "LIE", "LKA", "LBR", "LSO", "LTU", "LUX", "LVA", "LBY", "MAR", "MCO", "MDA", "MNE", "MAF", "MDG", "MHL", "MKD", "MLI", "MMR", "MNG", "MAC", "MNP", "MTQ", "MRT", "MSR", "MLT", "MUS", "MDV", "MWI", "MEX", "MYS", "MOZ", "NAM", "NCL", "NER", "NFK", "NGA", "NIC", "NLD", "NOR", "NPL", "NRU", "NIU", "NZL", "OMN", "PAN", "PER", "PYF", "PNG", "PHL", "PAK", "POL", "SPM", "PCN", "PRI", "PSE", "PRT", "PLW", "PRY", "QAT", "REU", "ROU", "SRB", "RUS", "RWA", "SAU", "SLB", "SYC", "SDN", "SWE", "SGP", "SHN", "SVN", "SJM", "SVK", "SLE", "SMR", "SEN", "SOM", "SUR", "STP", "SLV", "SYR", "SWZ", "TCA", "TCD", "ATF", "TGO", "THA", "TJK", "TKL", "TLS", "TKM", "TUN", "TON", "TUR", "TTO", "TUV", "TWN", "TZA", "UKR", "UGA", "UMI", "USA", "URY", "UZB", "VAT", "VCT", "VEN", "VGB", "VIR", "VNM", "VUT", "WLF", "WSM", "YEM", "MYT", "ZAF", "ZMB", "ZWE"};
            String[] tempObsoleteCountries3 = new String[]{"FXX", "SCG", "ROM", "TMP", "YUG", "ZAR"};
            Class clazz = class$com$ibm$icu$util$ULocale == null ? (class$com$ibm$icu$util$ULocale = ULocale.class$("com.ibm.icu.util.ULocale")) : class$com$ibm$icu$util$ULocale;
            synchronized (clazz) {
                if (_countries == null) {
                    _countries = tempCountries;
                    _deprecatedCountries = tempDeprecatedCountries;
                    _replacementCountries = tempReplacementCountries;
                    _obsoleteCountries = tempObsoleteCountries;
                    _countries3 = tempCountries3;
                    _obsoleteCountries3 = tempObsoleteCountries3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initCANONICALIZE_MAP() {
        Class clazz;
        if (CANONICALIZE_MAP == null) {
            String[][] tempCANONICALIZE_MAP = new String[][]{{"C", "en_US_POSIX", null, null}, {"art_LOJBAN", "jbo", null, null}, {"az_AZ_CYRL", "az_Cyrl_AZ", null, null}, {"az_AZ_LATN", "az_Latn_AZ", null, null}, {"ca_ES_PREEURO", "ca_ES", "currency", "ESP"}, {"cel_GAULISH", "cel__GAULISH", null, null}, {"de_1901", "de__1901", null, null}, {"de_1906", "de__1906", null, null}, {"de__PHONEBOOK", "de", "collation", "phonebook"}, {"de_AT_PREEURO", "de_AT", "currency", "ATS"}, {"de_DE_PREEURO", "de_DE", "currency", "DEM"}, {"de_LU_PREEURO", "de_LU", "currency", "EUR"}, {"el_GR_PREEURO", "el_GR", "currency", "GRD"}, {"en_BOONT", "en__BOONT", null, null}, {"en_SCOUSE", "en__SCOUSE", null, null}, {"en_BE_PREEURO", "en_BE", "currency", "BEF"}, {"en_IE_PREEURO", "en_IE", "currency", "IEP"}, {"es__TRADITIONAL", "es", "collation", "traditional"}, {"es_ES_PREEURO", "es_ES", "currency", "ESP"}, {"eu_ES_PREEURO", "eu_ES", "currency", "ESP"}, {"fi_FI_PREEURO", "fi_FI", "currency", "FIM"}, {"fr_BE_PREEURO", "fr_BE", "currency", "BEF"}, {"fr_FR_PREEURO", "fr_FR", "currency", "FRF"}, {"fr_LU_PREEURO", "fr_LU", "currency", "LUF"}, {"ga_IE_PREEURO", "ga_IE", "currency", "IEP"}, {"gl_ES_PREEURO", "gl_ES", "currency", "ESP"}, {"hi__DIRECT", "hi", "collation", "direct"}, {"it_IT_PREEURO", "it_IT", "currency", "ITL"}, {"ja_JP_TRADITIONAL", "ja_JP", "calendar", "japanese"}, {"nl_BE_PREEURO", "nl_BE", "currency", "BEF"}, {"nl_NL_PREEURO", "nl_NL", "currency", "NLG"}, {"pt_PT_PREEURO", "pt_PT", "currency", "PTE"}, {"sl_ROZAJ", "sl__ROZAJ", null, null}, {"sr_SP_CYRL", "sr_Cyrl_RS", null, null}, {"sr_SP_LATN", "sr_Latn_RS", null, null}, {"sr_YU_CYRILLIC", "sr_Cyrl_RS", null, null}, {"th_TH_TRADITIONAL", "th_TH", "calendar", "buddhist"}, {"uz_UZ_CYRILLIC", "uz_Cyrl_UZ", null, null}, {"uz_UZ_CYRL", "uz_Cyrl_UZ", null, null}, {"uz_UZ_LATN", "uz_Latn_UZ", null, null}, {"zh_CHS", "zh_Hans", null, null}, {"zh_CHT", "zh_Hant", null, null}, {"zh_GAN", "zh__GAN", null, null}, {"zh_GUOYU", "zh", null, null}, {"zh_HAKKA", "zh__HAKKA", null, null}, {"zh_MIN", "zh__MIN", null, null}, {"zh_MIN_NAN", "zh__MINNAN", null, null}, {"zh_WUU", "zh__WUU", null, null}, {"zh_XIANG", "zh__XIANG", null, null}, {"zh_YUE", "zh__YUE", null, null}};
            clazz = class$com$ibm$icu$util$ULocale == null ? (class$com$ibm$icu$util$ULocale = ULocale.class$("com.ibm.icu.util.ULocale")) : class$com$ibm$icu$util$ULocale;
            synchronized (clazz) {
                if (CANONICALIZE_MAP == null) {
                    CANONICALIZE_MAP = tempCANONICALIZE_MAP;
                }
            }
        }
        if (variantsToKeywords == null) {
            String[][] tempVariantsToKeywords = new String[][]{{"EURO", "currency", "EUR"}, {"PINYIN", "collation", "pinyin"}, {"STROKE", "collation", "stroke"}};
            clazz = class$com$ibm$icu$util$ULocale == null ? (class$com$ibm$icu$util$ULocale = ULocale.class$("com.ibm.icu.util.ULocale")) : class$com$ibm$icu$util$ULocale;
            synchronized (clazz) {
                if (variantsToKeywords == null) {
                    variantsToKeywords = tempVariantsToKeywords;
                }
            }
        }
    }

    private ULocale(String localeID, Locale locale) {
        this.localeID = localeID;
        this.locale = locale;
    }

    private ULocale(Locale loc) {
        this.localeID = ULocale.getName(ULocale.forLocale(loc).toString());
        this.locale = loc;
    }

    public static ULocale forLocale(Locale loc) {
        if (loc == null) {
            return null;
        }
        ULocale result = (ULocale)CACHE.get(loc);
        if (result == null) {
            if (defaultULocale != null && loc == ULocale.defaultULocale.locale) {
                result = defaultULocale;
            } else {
                String locStr = loc.toString();
                if (locStr.length() == 0) {
                    result = ROOT;
                } else {
                    for (int i = 0; i < _javaLocaleMap.length; ++i) {
                        if (!_javaLocaleMap[i][0].equals(locStr)) continue;
                        IDParser p = new IDParser(_javaLocaleMap[i][1]);
                        p.setKeywordValue(_javaLocaleMap[i][2], _javaLocaleMap[i][3]);
                        locStr = p.getName();
                        break;
                    }
                    result = new ULocale(locStr, loc);
                }
            }
            CACHE.put(loc, result);
        }
        return result;
    }

    public ULocale(String localeID) {
        this.localeID = ULocale.getName(localeID);
    }

    public ULocale(String a, String b) {
        this(a, b, null);
    }

    public ULocale(String a, String b, String c) {
        this.localeID = ULocale.getName(ULocale.lscvToID(a, b, c, EMPTY_STRING));
    }

    public static ULocale createCanonical(String nonCanonicalID) {
        return new ULocale(ULocale.canonicalize(nonCanonicalID), (Locale)null);
    }

    private static String lscvToID(String lang, String script, String country, String variant) {
        StringBuffer buf = new StringBuffer();
        if (lang != null && lang.length() > 0) {
            buf.append(lang);
        }
        if (script != null && script.length() > 0) {
            buf.append('_');
            buf.append(script);
        }
        if (country != null && country.length() > 0) {
            buf.append('_');
            buf.append(country);
        }
        if (variant != null && variant.length() > 0) {
            if (country == null || country.length() == 0) {
                buf.append('_');
            }
            buf.append('_');
            buf.append(variant);
        }
        return buf.toString();
    }

    public Locale toLocale() {
        if (this.locale == null) {
            IDParser p = new IDParser(this.localeID);
            String base = p.getBaseName();
            for (int i = 0; i < _javaLocaleMap.length; ++i) {
                if (!base.equals(_javaLocaleMap[i][1]) && !base.equals(_javaLocaleMap[i][4])) continue;
                if (_javaLocaleMap[i][2] != null) {
                    String val = p.getKeywordValue(_javaLocaleMap[i][2]);
                    if (val == null || !val.equals(_javaLocaleMap[i][3])) continue;
                    p = new IDParser(_javaLocaleMap[i][0]);
                    break;
                }
                p = new IDParser(_javaLocaleMap[i][0]);
                break;
            }
            String[] names = p.getLanguageScriptCountryVariant();
            this.locale = new Locale(names[0], names[2], names[3]);
        }
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ULocale getDefault() {
        Class clazz = class$com$ibm$icu$util$ULocale == null ? (class$com$ibm$icu$util$ULocale = ULocale.class$("com.ibm.icu.util.ULocale")) : class$com$ibm$icu$util$ULocale;
        synchronized (clazz) {
            Locale currentDefault = Locale.getDefault();
            if (!defaultLocale.equals(currentDefault)) {
                defaultLocale = currentDefault;
                defaultULocale = new ULocale(defaultLocale);
            }
            return defaultULocale;
        }
    }

    public static synchronized void setDefault(ULocale newLocale) {
        Locale.setDefault(newLocale.toLocale());
        defaultULocale = newLocale;
    }

    public Object clone() {
        return this;
    }

    public int hashCode() {
        return this.localeID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof String) {
            return this.localeID.equals((String)obj);
        }
        if (obj instanceof ULocale) {
            return this.localeID.equals(((ULocale)obj).localeID);
        }
        return false;
    }

    public static ULocale[] getAvailableLocales() {
        return ICUResourceBundle.getAvailableULocales();
    }

    public static VersionInfo getCLDRVersion() {
        if (gCLDRVersion == null) {
            UResourceBundle supplementalDataBundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle cldrVersionBundle = supplementalDataBundle.get("cldrVersion");
            gCLDRVersion = VersionInfo.getInstance(cldrVersionBundle.getString());
        }
        return gCLDRVersion;
    }

    public static String[] getISOCountries() {
        ULocale.initCountryTables();
        return (String[])_countries.clone();
    }

    public static String[] getISOLanguages() {
        ULocale.initLanguageTables();
        return (String[])_languages.clone();
    }

    public String getLanguage() {
        return ULocale.getLanguage(this.localeID);
    }

    public static String getLanguage(String localeID) {
        return new IDParser(localeID).getLanguage();
    }

    public String getScript() {
        return ULocale.getScript(this.localeID);
    }

    public static String getScript(String localeID) {
        return new IDParser(localeID).getScript();
    }

    public String getCountry() {
        return ULocale.getCountry(this.localeID);
    }

    public static String getCountry(String localeID) {
        return new IDParser(localeID).getCountry();
    }

    public String getVariant() {
        return ULocale.getVariant(this.localeID);
    }

    public static String getVariant(String localeID) {
        return new IDParser(localeID).getVariant();
    }

    public static String getFallback(String localeID) {
        return ULocale.getFallbackString(ULocale.getName(localeID));
    }

    public ULocale getFallback() {
        if (this.localeID.length() == 0 || this.localeID.charAt(0) == '@') {
            return null;
        }
        return new ULocale(ULocale.getFallbackString(this.localeID), (Locale)null);
    }

    private static String getFallbackString(String fallback) {
        int start;
        int limit = fallback.indexOf(64);
        if (limit == -1) {
            limit = fallback.length();
        }
        if ((start = fallback.lastIndexOf(95, limit)) == -1) {
            start = 0;
        }
        return fallback.substring(0, start) + fallback.substring(limit);
    }

    public String getBaseName() {
        return ULocale.getBaseName(this.localeID);
    }

    public static String getBaseName(String localeID) {
        if (localeID.indexOf(64) == -1) {
            return localeID;
        }
        return new IDParser(localeID).getBaseName();
    }

    public String getName() {
        return this.localeID;
    }

    public static String getName(String localeID) {
        String name = (String)nameCache.get(localeID);
        if (name == null) {
            name = new IDParser(localeID).getName();
            nameCache.put(localeID, name);
        }
        return name;
    }

    public String toString() {
        return this.localeID;
    }

    public Iterator getKeywords() {
        return ULocale.getKeywords(this.localeID);
    }

    public static Iterator getKeywords(String localeID) {
        return new IDParser(localeID).getKeywords();
    }

    public String getKeywordValue(String keywordName) {
        return ULocale.getKeywordValue(this.localeID, keywordName);
    }

    public static String getKeywordValue(String localeID, String keywordName) {
        return new IDParser(localeID).getKeywordValue(keywordName);
    }

    private static int findIndex(String[] array, String target) {
        for (int i = 0; i < array.length; ++i) {
            if (!target.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static String canonicalize(String localeID) {
        String[] vals;
        int i;
        IDParser parser = new IDParser(localeID, true);
        String baseName = parser.getBaseName();
        boolean foundVariant = false;
        if (localeID.equals(EMPTY_STRING)) {
            return EMPTY_STRING;
        }
        ULocale.initCANONICALIZE_MAP();
        for (i = 0; i < variantsToKeywords.length; ++i) {
            vals = variantsToKeywords[i];
            int idx = baseName.lastIndexOf("_" + vals[0]);
            if (idx <= -1) continue;
            foundVariant = true;
            if ((baseName = baseName.substring(0, idx)).endsWith("_")) {
                baseName = baseName.substring(0, --idx);
            }
            parser.setBaseName(baseName);
            parser.defaultKeywordValue(vals[1], vals[2]);
            break;
        }
        for (i = 0; i < CANONICALIZE_MAP.length; ++i) {
            if (!CANONICALIZE_MAP[i][0].equals(baseName)) continue;
            foundVariant = true;
            vals = CANONICALIZE_MAP[i];
            parser.setBaseName(vals[1]);
            if (vals[2] == null) break;
            parser.defaultKeywordValue(vals[2], vals[3]);
            break;
        }
        if (!foundVariant && parser.getLanguage().equals("nb") && parser.getVariant().equals("NY")) {
            parser.setBaseName(ULocale.lscvToID("nn", parser.getScript(), parser.getCountry(), null));
        }
        return parser.getName();
    }

    public ULocale setKeywordValue(String keyword, String value) {
        return new ULocale(ULocale.setKeywordValue(this.localeID, keyword, value), (Locale)null);
    }

    public static String setKeywordValue(String localeID, String keyword, String value) {
        IDParser parser = new IDParser(localeID);
        parser.setKeywordValue(keyword, value);
        return parser.getName();
    }

    public String getISO3Language() {
        return ULocale.getISO3Language(this.localeID);
    }

    public static String getISO3Language(String localeID) {
        ULocale.initLanguageTables();
        String language = ULocale.getLanguage(localeID);
        int offset = ULocale.findIndex(_languages, language);
        if (offset >= 0) {
            return _languages3[offset];
        }
        offset = ULocale.findIndex(_obsoleteLanguages, language);
        if (offset >= 0) {
            return _obsoleteLanguages3[offset];
        }
        return EMPTY_STRING;
    }

    public String getISO3Country() {
        return ULocale.getISO3Country(this.localeID);
    }

    public static String getISO3Country(String localeID) {
        ULocale.initCountryTables();
        String country = ULocale.getCountry(localeID);
        int offset = ULocale.findIndex(_countries, country);
        if (offset >= 0) {
            return _countries3[offset];
        }
        offset = ULocale.findIndex(_obsoleteCountries, country);
        if (offset >= 0) {
            return _obsoleteCountries3[offset];
        }
        return EMPTY_STRING;
    }

    private static String getTableString(String tableName, String subtableName, String item, String displayLocaleID) {
        if (item.length() > 0) {
            try {
                ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", displayLocaleID);
                return ULocale.getTableString(tableName, subtableName, item, bundle);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return item;
    }

    private static String getTableString(String tableName, String subtableName, String item, ICUResourceBundle bundle) {
        try {
            while (true) {
                ICUResourceBundle table;
                if ("currency".equals(subtableName)) {
                    table = bundle.getWithFallback("Currencies");
                    table = table.getWithFallback(item);
                    return table.getString(1);
                }
                table = bundle.getWithFallback(tableName);
                try {
                    if (subtableName != null) {
                        table = table.getWithFallback(subtableName);
                    }
                    return table.getStringWithFallback(item);
                }
                catch (MissingResourceException e) {
                    String fallbackLocale;
                    if (subtableName == null) {
                        try {
                            String currentName = null;
                            if (tableName.equals("Countries")) {
                                currentName = ULocale.getCurrentCountryID(item);
                            } else if (tableName.equals("Languages")) {
                                currentName = ULocale.getCurrentLanguageID(item);
                            }
                            return table.getStringWithFallback(currentName);
                        }
                        catch (MissingResourceException ex) {
                            // empty catch block
                        }
                    }
                    if ((fallbackLocale = table.getWithFallback("Fallback").getString()).length() == 0) {
                        fallbackLocale = "root";
                    }
                    if (fallbackLocale.equals(table.getULocale().localeID)) {
                        return item;
                    }
                    bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", fallbackLocale);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            return item;
        }
    }

    public String getDisplayLanguage() {
        return ULocale.getDisplayLanguageInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayLanguage(ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayLanguage(String localeID, String displayLocaleID) {
        return ULocale.getDisplayLanguageInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayLanguage(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayLanguageInternal(localeID, displayLocale.localeID);
    }

    static String getCurrentCountryID(String oldID) {
        ULocale.initCountryTables();
        int offset = ULocale.findIndex(_deprecatedCountries, oldID);
        if (offset >= 0) {
            return _replacementCountries[offset];
        }
        return oldID;
    }

    static String getCurrentLanguageID(String oldID) {
        ULocale.initLanguageTables();
        int offset = ULocale.findIndex(_obsoleteLanguages, oldID);
        if (offset >= 0) {
            return _replacementLanguages[offset];
        }
        return oldID;
    }

    private static String getDisplayLanguageInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Languages", null, new IDParser(localeID).getLanguage(), displayLocaleID);
    }

    public String getDisplayScript() {
        return ULocale.getDisplayScriptInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayScript(ULocale displayLocale) {
        return ULocale.getDisplayScriptInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayScript(String localeID, String displayLocaleID) {
        return ULocale.getDisplayScriptInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayScript(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayScriptInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayScriptInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Scripts", null, new IDParser(localeID).getScript(), displayLocaleID);
    }

    public String getDisplayCountry() {
        return ULocale.getDisplayCountryInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayCountry(ULocale displayLocale) {
        return ULocale.getDisplayCountryInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayCountry(String localeID, String displayLocaleID) {
        return ULocale.getDisplayCountryInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayCountry(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayCountryInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayCountryInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Countries", null, new IDParser(localeID).getCountry(), displayLocaleID);
    }

    public String getDisplayVariant() {
        return ULocale.getDisplayVariantInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayVariant(ULocale displayLocale) {
        return ULocale.getDisplayVariantInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayVariant(String localeID, String displayLocaleID) {
        return ULocale.getDisplayVariantInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayVariant(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayVariantInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayVariantInternal(String localeID, String displayLocaleID) {
        return ULocale.getTableString("Variants", null, new IDParser(localeID).getVariant(), displayLocaleID);
    }

    public static String getDisplayKeyword(String keyword) {
        return ULocale.getDisplayKeywordInternal(keyword, ULocale.getDefault().localeID);
    }

    public static String getDisplayKeyword(String keyword, String displayLocaleID) {
        return ULocale.getDisplayKeywordInternal(keyword, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayKeyword(String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordInternal(keyword, displayLocale.localeID);
    }

    private static String getDisplayKeywordInternal(String keyword, String displayLocaleID) {
        return ULocale.getTableString("Keys", null, AsciiUtil.toLowerString(keyword.trim()), displayLocaleID);
    }

    public String getDisplayKeywordValue(String keyword) {
        return ULocale.getDisplayKeywordValueInternal(this.localeID, keyword, ULocale.getDefault().localeID);
    }

    public String getDisplayKeywordValue(String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordValueInternal(this.localeID, keyword, displayLocale.localeID);
    }

    public static String getDisplayKeywordValue(String localeID, String keyword, String displayLocaleID) {
        return ULocale.getDisplayKeywordValueInternal(localeID, keyword, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayKeywordValue(String localeID, String keyword, ULocale displayLocale) {
        return ULocale.getDisplayKeywordValueInternal(localeID, keyword, displayLocale.localeID);
    }

    private static String getDisplayKeywordValueInternal(String localeID, String keyword, String displayLocaleID) {
        keyword = AsciiUtil.toLowerString(keyword.trim());
        String value = new IDParser(localeID).getKeywordValue(keyword);
        return ULocale.getTableString("Types", keyword, value, displayLocaleID);
    }

    public String getDisplayName() {
        return ULocale.getDisplayNameInternal(this.localeID, ULocale.getDefault().localeID);
    }

    public String getDisplayName(ULocale displayLocale) {
        return ULocale.getDisplayNameInternal(this.localeID, displayLocale.localeID);
    }

    public static String getDisplayName(String localeID, String displayLocaleID) {
        return ULocale.getDisplayNameInternal(localeID, ULocale.getName(displayLocaleID));
    }

    public static String getDisplayName(String localeID, ULocale displayLocale) {
        return ULocale.getDisplayNameInternal(localeID, displayLocale.localeID);
    }

    private static String getDisplayNameInternal(String localeID, String displayLocaleID) {
        String[] tableNames = new String[]{"Languages", "Scripts", "Countries", "Variants"};
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", displayLocaleID);
        StringBuffer buf = new StringBuffer();
        IDParser parser = new IDParser(localeID);
        String[] names = parser.getLanguageScriptCountryVariant();
        boolean haveLanguage = names[0].length() > 0;
        boolean openParen = false;
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name.length() <= 0) continue;
            name = ULocale.getTableString(tableNames[i], null, name, bundle);
            if (buf.length() > 0) {
                if (haveLanguage & !openParen) {
                    buf.append(" (");
                    openParen = true;
                } else {
                    buf.append(", ");
                }
            }
            buf.append(name);
        }
        Map m = parser.getKeywordMap();
        if (!m.isEmpty()) {
            Iterator keys = m.entrySet().iterator();
            while (keys.hasNext()) {
                if (buf.length() > 0) {
                    if (haveLanguage & !openParen) {
                        buf.append(" (");
                        openParen = true;
                    } else {
                        buf.append(", ");
                    }
                }
                Map.Entry e = keys.next();
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                buf.append(ULocale.getTableString("Keys", null, key, bundle));
                buf.append("=");
                buf.append(ULocale.getTableString("Types", key, val, bundle));
            }
        }
        if (openParen) {
            buf.append(")");
        }
        return buf.toString();
    }

    public String getCharacterOrientation() {
        return ULocale.getTableString("layout", null, "characters", this.getName());
    }

    public String getLineOrientation() {
        return ULocale.getTableString("layout", null, "lines", this.getName());
    }

    public static ULocale acceptLanguage(String acceptLanguageList, ULocale[] availableLocales, boolean[] fallback) {
        if (acceptLanguageList == null) {
            throw new NullPointerException();
        }
        ULocale[] acceptList = null;
        try {
            acceptList = ULocale.parseAcceptLanguage(acceptLanguageList, true);
        }
        catch (ParseException pe) {
            acceptList = null;
        }
        if (acceptList == null) {
            return null;
        }
        return ULocale.acceptLanguage(acceptList, availableLocales, fallback);
    }

    public static ULocale acceptLanguage(ULocale[] acceptLanguageList, ULocale[] availableLocales, boolean[] fallback) {
        if (fallback != null) {
            fallback[0] = true;
        }
        for (int i = 0; i < acceptLanguageList.length; ++i) {
            ULocale aLocale = acceptLanguageList[i];
            boolean[] setFallback = fallback;
            do {
                for (int j = 0; j < availableLocales.length; ++j) {
                    if (!availableLocales[j].equals(aLocale)) continue;
                    if (setFallback != null) {
                        setFallback[0] = false;
                    }
                    return availableLocales[j];
                }
                Locale loc = aLocale.toLocale();
                Locale parent = LocaleUtility.fallback(loc);
                aLocale = parent != null ? new ULocale(parent) : null;
                setFallback = null;
            } while (aLocale != null);
        }
        return null;
    }

    public static ULocale acceptLanguage(String acceptLanguageList, boolean[] fallback) {
        return ULocale.acceptLanguage(acceptLanguageList, ULocale.getAvailableLocales(), fallback);
    }

    public static ULocale acceptLanguage(ULocale[] acceptLanguageList, boolean[] fallback) {
        return ULocale.acceptLanguage(acceptLanguageList, ULocale.getAvailableLocales(), fallback);
    }

    static ULocale[] parseAcceptLanguage(String acceptLanguage, boolean isLenient) throws ParseException {
        int n;
        class ULocaleAcceptLanguageQ
        implements Comparable {
            private double q;
            private double serial;

            public ULocaleAcceptLanguageQ(double theq, int theserial) {
                this.q = theq;
                this.serial = theserial;
            }

            public int compareTo(Object o) {
                ULocaleAcceptLanguageQ other = (ULocaleAcceptLanguageQ)o;
                if (this.q > other.q) {
                    return -1;
                }
                if (this.q < other.q) {
                    return 1;
                }
                if (this.serial < other.serial) {
                    return -1;
                }
                if (this.serial > other.serial) {
                    return 1;
                }
                return 0;
            }
        }
        TreeMap<ULocaleAcceptLanguageQ, ULocale> map = new TreeMap<ULocaleAcceptLanguageQ, ULocale>();
        StringBuffer languageRangeBuf = new StringBuffer();
        StringBuffer qvalBuf = new StringBuffer();
        int state = 0;
        acceptLanguage = acceptLanguage + ",";
        boolean subTag = false;
        boolean q1 = false;
        for (n = 0; n < acceptLanguage.length(); ++n) {
            boolean gotLanguageQ = false;
            char c = acceptLanguage.charAt(n);
            switch (state) {
                case 0: {
                    if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                        languageRangeBuf.append(c);
                        state = 1;
                        subTag = false;
                        break;
                    }
                    if (c == '*') {
                        languageRangeBuf.append(c);
                        state = 2;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 1: {
                    if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                        languageRangeBuf.append(c);
                        break;
                    }
                    if (c == '-') {
                        subTag = true;
                        languageRangeBuf.append(c);
                        break;
                    }
                    if (c == '_') {
                        if (isLenient) {
                            subTag = true;
                            languageRangeBuf.append(c);
                            break;
                        }
                        state = -1;
                        break;
                    }
                    if ('0' <= c && c <= '9') {
                        if (subTag) {
                            languageRangeBuf.append(c);
                            break;
                        }
                        state = -1;
                        break;
                    }
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 3;
                        break;
                    }
                    if (c == ';') {
                        state = 4;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 2: {
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 3;
                        break;
                    }
                    if (c == ';') {
                        state = 4;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 3: {
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ';') {
                        state = 4;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 4: {
                    if (c == 'q') {
                        state = 5;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 5: {
                    if (c == '=') {
                        state = 6;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 6: {
                    if (c == '0') {
                        q1 = false;
                        qvalBuf.append(c);
                        state = 7;
                        break;
                    }
                    if (c == '1') {
                        qvalBuf.append(c);
                        state = 7;
                        break;
                    }
                    if (c == '.') {
                        if (isLenient) {
                            qvalBuf.append(c);
                            state = 8;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                    break;
                }
                case 7: {
                    if (c == '.') {
                        qvalBuf.append(c);
                        state = 8;
                        break;
                    }
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 10;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 8: {
                    if ('0' <= c || c <= '9') {
                        if (q1 && c != '0' && !isLenient) {
                            state = -1;
                            break;
                        }
                        qvalBuf.append(c);
                        state = 9;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 9: {
                    if ('0' <= c && c <= '9') {
                        if (q1 && c != '0') {
                            state = -1;
                            break;
                        }
                        qvalBuf.append(c);
                        break;
                    }
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') {
                        state = 10;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 10: {
                    if (c == ',') {
                        gotLanguageQ = true;
                        break;
                    }
                    if (c == ' ' || c == '\t') break;
                    state = -1;
                }
            }
            if (state == -1) {
                throw new ParseException("Invalid Accept-Language", n);
            }
            if (!gotLanguageQ) continue;
            double q = 1.0;
            if (qvalBuf.length() != 0) {
                try {
                    q = Double.parseDouble(qvalBuf.toString());
                }
                catch (NumberFormatException nfe) {
                    q = 1.0;
                }
                if (q > 1.0) {
                    q = 1.0;
                }
            }
            if (languageRangeBuf.charAt(0) != '*') {
                int serial = map.size();
                ULocaleAcceptLanguageQ entry = new ULocaleAcceptLanguageQ(q, serial);
                map.put(entry, new ULocale(ULocale.canonicalize(languageRangeBuf.toString())));
            }
            languageRangeBuf.setLength(0);
            qvalBuf.setLength(0);
            state = 0;
        }
        if (state != 0) {
            throw new ParseException("Invalid AcceptlLanguage", n);
        }
        ULocale[] acceptList = map.values().toArray(new ULocale[map.size()]);
        return acceptList;
    }

    public static ULocale addLikelySubtags(ULocale loc) {
        String newLocaleID;
        String[] tags = new String[3];
        String trailing = null;
        int trailingIndex = ULocale.parseTagString(loc.localeID, tags);
        if (trailingIndex < loc.localeID.length()) {
            trailing = loc.localeID.substring(trailingIndex);
        }
        return (newLocaleID = ULocale.createLikelySubtagsString(tags[0], tags[1], tags[2], trailing)) == null ? loc : new ULocale(newLocaleID);
    }

    public static ULocale minimizeSubtags(ULocale loc) {
        String maximizedLocaleID;
        String[] tags = new String[3];
        int trailingIndex = ULocale.parseTagString(loc.localeID, tags);
        String originalLang = tags[0];
        String originalScript = tags[1];
        String originalRegion = tags[2];
        String originalTrailing = null;
        if (trailingIndex < loc.localeID.length()) {
            originalTrailing = loc.localeID.substring(trailingIndex);
        }
        if (ULocale.isEmptyString(maximizedLocaleID = ULocale.createLikelySubtagsString(originalLang, originalScript, originalRegion, null))) {
            return loc;
        }
        String tag = ULocale.createLikelySubtagsString(originalLang, null, null, null);
        if (tag.equals(maximizedLocaleID)) {
            String newLocaleID = ULocale.createTagString(originalLang, null, null, originalTrailing);
            return new ULocale(newLocaleID);
        }
        if (originalRegion.length() != 0 && (tag = ULocale.createLikelySubtagsString(originalLang, null, originalRegion, null)).equals(maximizedLocaleID)) {
            String newLocaleID = ULocale.createTagString(originalLang, null, originalRegion, originalTrailing);
            return new ULocale(newLocaleID);
        }
        if (originalRegion.length() != 0 && originalScript.length() != 0 && (tag = ULocale.createLikelySubtagsString(originalLang, originalScript, null, null)).equals(maximizedLocaleID)) {
            String newLocaleID = ULocale.createTagString(originalLang, originalScript, null, originalTrailing);
            return new ULocale(newLocaleID);
        }
        return loc;
    }

    private static boolean isEmptyString(String string) {
        return string == null || string.length() == 0;
    }

    private static void appendTag(String tag, StringBuffer buffer) {
        if (buffer.length() != 0) {
            buffer.append('_');
        }
        buffer.append(tag);
    }

    private static String createTagString(String lang, String script, String region, String trailing, String alternateTags) {
        IDParser parser = null;
        boolean regionAppended = false;
        StringBuffer tag = new StringBuffer();
        if (!ULocale.isEmptyString(lang)) {
            ULocale.appendTag(lang, tag);
        } else if (ULocale.isEmptyString(alternateTags)) {
            ULocale.appendTag(UNDEFINED_LANGUAGE, tag);
        } else {
            parser = new IDParser(alternateTags);
            String alternateLang = parser.getLanguage();
            ULocale.appendTag(!ULocale.isEmptyString(alternateLang) ? alternateLang : UNDEFINED_LANGUAGE, tag);
        }
        if (!ULocale.isEmptyString(script)) {
            ULocale.appendTag(script, tag);
        } else if (!ULocale.isEmptyString(alternateTags)) {
            String alternateScript;
            if (parser == null) {
                parser = new IDParser(alternateTags);
            }
            if (!ULocale.isEmptyString(alternateScript = parser.getScript())) {
                ULocale.appendTag(alternateScript, tag);
            }
        }
        if (!ULocale.isEmptyString(region)) {
            ULocale.appendTag(region, tag);
            regionAppended = true;
        } else if (!ULocale.isEmptyString(alternateTags)) {
            String alternateRegion;
            if (parser == null) {
                parser = new IDParser(alternateTags);
            }
            if (!ULocale.isEmptyString(alternateRegion = parser.getCountry())) {
                ULocale.appendTag(alternateRegion, tag);
                regionAppended = true;
            }
        }
        if (trailing != null && trailing.length() > 1) {
            int separators = 0;
            if (trailing.charAt(0) == '_') {
                if (trailing.charAt(1) == '_') {
                    separators = 2;
                }
            } else {
                separators = 1;
            }
            if (regionAppended) {
                if (separators == 2) {
                    tag.append(trailing.substring(1));
                } else {
                    tag.append(trailing);
                }
            } else {
                if (separators == 1) {
                    tag.append('_');
                }
                tag.append(trailing);
            }
        }
        return tag.toString();
    }

    static String createTagString(String lang, String script, String region, String trailing) {
        return ULocale.createTagString(lang, script, region, trailing, null);
    }

    private static int parseTagString(String localeID, String[] tags) {
        IDParser parser = new IDParser(localeID);
        String lang = parser.getLanguage();
        String script = parser.getScript();
        String region = parser.getCountry();
        tags[0] = ULocale.isEmptyString(lang) ? UNDEFINED_LANGUAGE : lang;
        tags[1] = script.equals(UNDEFINED_SCRIPT) ? EMPTY_STRING : script;
        tags[2] = region.equals(UNDEFINED_REGION) ? EMPTY_STRING : region;
        String variant = parser.getVariant();
        if (!ULocale.isEmptyString(variant)) {
            int index = localeID.indexOf(variant);
            return index > 0 ? index - 1 : index;
        }
        int index = localeID.indexOf(64);
        return index == -1 ? localeID.length() : index;
    }

    private static String lookupLikelySubtags(String localeId) {
        UResourceBundle bundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", "likelySubtags");
        try {
            return bundle.getString(localeId);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static String createLikelySubtagsString(String lang, String script, String region, String variants) {
        String searchTag;
        String likelySubtags;
        if (!ULocale.isEmptyString(script) && !ULocale.isEmptyString(region) && (likelySubtags = ULocale.lookupLikelySubtags(searchTag = ULocale.createTagString(lang, script, region, null))) != null) {
            return ULocale.createTagString(null, null, null, variants, likelySubtags);
        }
        if (!ULocale.isEmptyString(script) && (likelySubtags = ULocale.lookupLikelySubtags(searchTag = ULocale.createTagString(lang, script, null, null))) != null) {
            return ULocale.createTagString(null, null, region, variants, likelySubtags);
        }
        if (!ULocale.isEmptyString(region) && (likelySubtags = ULocale.lookupLikelySubtags(searchTag = ULocale.createTagString(lang, null, region, null))) != null) {
            return ULocale.createTagString(null, script, null, variants, likelySubtags);
        }
        searchTag = ULocale.createTagString(lang, null, null, null);
        likelySubtags = ULocale.lookupLikelySubtags(searchTag);
        if (likelySubtags != null) {
            return ULocale.createTagString(null, script, region, variants, likelySubtags);
        }
        return null;
    }

    public String getExtension(char key) {
        if (!LocaleExtensions.isValidExtensionKey(key)) {
            throw new IllegalArgumentException("Invalid extension key: " + key);
        }
        return this.extensions().getExtensionValue(key);
    }

    public Set getExtensionKeys() {
        return this.extensions().getExtensionKeys();
    }

    public String getLDMLExtensionValue(String key) {
        if (!LocaleExtensions.isValidLDMLKey(key)) {
            throw new IllegalArgumentException("Invalid LDML key: " + key);
        }
        return this.extensions().getLDMLKeywordType(key);
    }

    public Set getLDMLExtensionKeys() {
        return this.extensions().getLDMLKeywordKeys();
    }

    public String toLanguageTag() {
        return LanguageTag.toLanguageTag(this.base(), this.extensions());
    }

    public static ULocale forLanguageTag(String langtag) {
        ULocale locale = new ULocale(EMPTY_STRING);
        LanguageTag tag = null;
        while (true) {
            try {
                String language;
                tag = LanguageTag.parse(langtag);
                Builder bldr = new Builder();
                String extlang = tag.getExtlang(0);
                String string = language = extlang == null ? tag.getLanguage() : extlang;
                if (!language.equals(UNDEFINED_LANGUAGE)) {
                    bldr.setLanguage(language);
                }
                bldr.setScript(tag.getScript()).setRegion(tag.getRegion()).setVariant(tag.getVariant());
                Set exts = tag.getExtensions();
                if (exts != null) {
                    Iterator itr = exts.iterator();
                    while (itr.hasNext()) {
                        LanguageTag.Extension e = (LanguageTag.Extension)itr.next();
                        bldr.setExtension(e.getSingleton(), e.getValue());
                    }
                }
                bldr.setExtension('x', tag.getPrivateUse());
                locale = bldr.create();
                break;
            }
            catch (LocaleSyntaxException e) {
            }
            catch (IllformedLocaleException e) {
                // empty catch block
            }
            int idx = langtag.lastIndexOf(45);
            if (idx == -1) break;
            langtag = langtag.substring(0, idx);
        }
        return locale;
    }

    private static ULocale getInstance(BaseLocale base, LocaleExtensions ext) {
        StringBuffer id = new StringBuffer(base.getID());
        TreeMap<String, String> kwds = null;
        Set extKeys = ext.getExtensionKeys();
        if (extKeys != null) {
            Set ldmlKeys;
            kwds = new TreeMap<String, String>();
            Iterator itr = extKeys.iterator();
            boolean hasLDMLKeywords = false;
            while (itr.hasNext()) {
                Character key = (Character)itr.next();
                if (key.charValue() == 'u') {
                    hasLDMLKeywords = true;
                    continue;
                }
                String value = ext.getExtensionValue(key.charValue());
                kwds.put(String.valueOf(key), value);
            }
            if (hasLDMLKeywords && (ldmlKeys = ext.getLDMLKeywordKeys()) != null) {
                Iterator litr = ldmlKeys.iterator();
                while (litr.hasNext()) {
                    String bcpKey = (String)litr.next();
                    String bcpValue = ext.getLDMLKeywordType(bcpKey);
                    String lkey = ULocale.bcp47ToLDMLKey(bcpKey);
                    String ltype = ULocale.bcp47ToLDMLType(lkey, bcpValue);
                    kwds.put(lkey, ltype);
                }
            }
            if (kwds.size() > 0) {
                id.append("@");
                Set kset = kwds.entrySet();
                Iterator kitr = kset.iterator();
                boolean insertSep = false;
                while (kitr.hasNext()) {
                    if (insertSep) {
                        id.append(";");
                    } else {
                        insertSep = true;
                    }
                    Map.Entry kwd = kitr.next();
                    id.append(kwd.getKey());
                    id.append("=");
                    id.append(kwd.getValue());
                }
            }
        }
        return new ULocale(id.toString());
    }

    private BaseLocale base() {
        String language = this.getLanguage();
        if (this.equals(ROOT)) {
            language = EMPTY_STRING;
        }
        return BaseLocale.getInstance(language, this.getScript(), this.getCountry(), this.getVariant());
    }

    private LocaleExtensions extensions() {
        Iterator kwitr = this.getKeywords();
        if (kwitr == null) {
            return LocaleExtensions.EMPTY_EXTENSIONS;
        }
        TreeMap<Character, String> extMap = null;
        TreeMap<String, String> ldmlKwMap = null;
        while (kwitr.hasNext()) {
            String key = (String)kwitr.next();
            String value = this.getKeywordValue(key);
            if (key.length() == 1) {
                boolean isPrivUse;
                boolean bl = isPrivUse = key.charAt(0) == 'x';
                if (!isPrivUse && !LanguageTag.isExtensionSingleton(key)) continue;
                boolean isValid = true;
                String[] subtags = Utility.split(value, '-');
                for (int i = 0; i < subtags.length; ++i) {
                    if (isPrivUse) {
                        if (LanguageTag.isPrivateuseValueSubtag(subtags[i])) continue;
                        isValid = false;
                        break;
                    }
                    if (LanguageTag.isExtensionSubtag(subtags[i])) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) continue;
                if (extMap == null) {
                    extMap = new TreeMap();
                }
                extMap.put(new Character(key.charAt(0)), value.intern());
                continue;
            }
            String bcpKey = ULocale.ldmlKeyToBCP47(key);
            String bcpVal = ULocale.ldmlTypeToBCP47(key, value);
            if (bcpKey == null || bcpVal == null) continue;
            if (ldmlKwMap == null) {
                ldmlKwMap = new TreeMap<String, String>();
            }
            ldmlKwMap.put(bcpKey.intern(), bcpVal.intern());
        }
        if (ldmlKwMap != null) {
            StringBuffer buf = new StringBuffer();
            LocaleExtensions.keywordsToString(ldmlKwMap, buf);
            if (extMap == null) {
                extMap = new TreeMap<Character, String>();
            }
            extMap.put(new Character('u'), buf.toString().intern());
        }
        return LocaleExtensions.getInstance(extMap, ldmlKwMap);
    }

    private static String ldmlKeyToBCP47(String key) {
        UResourceBundle supplemental = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle bcp47Mappings = supplemental.get("bcp47KeywordMappings");
        UResourceBundle keyMaps = bcp47Mappings.get("key");
        key = AsciiUtil.toLowerString(key);
        String bcpKey = null;
        try {
            bcpKey = keyMaps.getString(key);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        if (bcpKey == null) {
            if (key.length() == 2 && LanguageTag.isExtensionSubtag(key)) {
                return key;
            }
            return null;
        }
        return bcpKey;
    }

    private static String bcp47ToLDMLKey(String bcpKey) {
        UResourceBundle supplemental = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle bcp47Mappings = supplemental.get("bcp47KeywordMappings");
        UResourceBundle keyMaps = bcp47Mappings.get("key");
        bcpKey = AsciiUtil.toLowerString(bcpKey);
        String key = null;
        for (int i = 0; i < keyMaps.getSize(); ++i) {
            UResourceBundle keyMap = keyMaps.get(i);
            if (!bcpKey.equals(keyMap.getString())) continue;
            key = keyMap.getKey();
            break;
        }
        if (key == null) {
            return bcpKey;
        }
        return key;
    }

    private static String ldmlTypeToBCP47(String key, String type) {
        UResourceBundle supplemental = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle bcp47Mappings = supplemental.get("bcp47KeywordMappings");
        key = AsciiUtil.toLowerString(key);
        type = AsciiUtil.toLowerString(type);
        String bcpType = null;
        try {
            UResourceBundle typeMaps = bcp47Mappings.get(key);
            String tmp = key.equals("timezone") ? Utility.replaceAll(type, "/", ":") : type;
            bcpType = typeMaps.getString(tmp);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        if (bcpType == null) {
            int typeLen = type.length();
            if (typeLen >= 3 && typeLen <= 8 && LanguageTag.isExtensionSubtag(type)) {
                return type;
            }
            return null;
        }
        return bcpType;
    }

    private static String bcp47ToLDMLType(String key, String bcpType) {
        UResourceBundle supplemental = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle bcp47Mappings = supplemental.get("bcp47KeywordMappings");
        key = AsciiUtil.toLowerString(key);
        bcpType = AsciiUtil.toLowerString(bcpType);
        String type = null;
        try {
            UResourceBundle typeMaps = bcp47Mappings.get(key);
            for (int i = 0; i < typeMaps.getSize(); ++i) {
                UResourceBundle typeMap = typeMaps.get(i);
                if (!bcpType.equals(typeMap.getString())) continue;
                type = typeMap.getKey();
                if (key.equals("timezone")) {
                    type = Utility.replaceAll(type, ":", "/");
                }
                break;
            }
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        if (type == null) {
            return bcpType;
        }
        return type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PRC = CHINA = new ULocale("zh_Hans_CN", Locale.CHINA);
        TAIWAN = new ULocale("zh_Hant_TW", Locale.TAIWAN);
        UK = new ULocale("en_GB", Locale.UK);
        US = new ULocale("en_US", Locale.US);
        CANADA = new ULocale("en_CA", Locale.CANADA);
        CANADA_FRENCH = new ULocale("fr_CA", Locale.CANADA_FRENCH);
        EMPTY_LOCALE = new Locale(EMPTY_STRING, EMPTY_STRING);
        ROOT = new ULocale("root", EMPTY_LOCALE);
        CACHE = new SimpleCache();
        _javaLocaleMap = new String[][]{{"ja_JP_JP", "ja_JP", "calendar", "japanese", "ja"}, {"no_NO_NY", "nn_NO", null, null, "nn"}, {"th_TH_TH", "th_TH", "numbers", "thai", "th"}};
        nameCache = new SimpleCache();
        defaultLocale = Locale.getDefault();
        defaultULocale = new ULocale(defaultLocale);
        gCLDRVersion = null;
        ACTUAL_LOCALE = new Type();
        VALID_LOCALE = new Type();
    }

    public static final class Builder {
        private InternalLocaleBuilder _locbld = new InternalLocaleBuilder();

        public Builder setLocale(ULocale loc) {
            this.clear();
            this.setLanguage(loc.getLanguage()).setScript(loc.getScript()).setRegion(loc.getCountry()).setVariant(loc.getVariant());
            Set extKeys = loc.getExtensionKeys();
            if (extKeys != null) {
                Iterator itr = extKeys.iterator();
                while (itr.hasNext()) {
                    char key = ((Character)itr.next()).charValue();
                    String value = loc.getExtension(key);
                    if (value == null || value.length() <= 0) continue;
                    this.setExtension(key, value);
                }
            }
            return this;
        }

        public Builder setLanguageTag(String langtag) {
            this.clear();
            LanguageTag tag = null;
            try {
                tag = LanguageTag.parse(langtag);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            String extlang = tag.getExtlang(0);
            String language = extlang == null ? tag.getLanguage() : extlang;
            this.setLanguage(language.equals(ULocale.UNDEFINED_LANGUAGE) ? ULocale.EMPTY_STRING : language).setScript(tag.getScript()).setRegion(tag.getRegion()).setVariant(tag.getVariant());
            Set exts = tag.getExtensions();
            if (exts != null) {
                Iterator itr = exts.iterator();
                while (itr.hasNext()) {
                    LanguageTag.Extension e = (LanguageTag.Extension)itr.next();
                    this.setExtension(e.getSingleton(), e.getValue());
                }
            }
            this.setExtension('x', tag.getPrivateUse());
            return this;
        }

        public Builder setLanguage(String language) {
            try {
                this._locbld.setLanguage(language);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setScript(String script) {
            try {
                this._locbld.setScript(script);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setRegion(String region) {
            try {
                this._locbld.setRegion(region);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setVariant(String variant) {
            try {
                this._locbld.setVariant(variant);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setExtension(char key, String value) {
            try {
                this._locbld.setExtension(key, value);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setLDMLExtensionValue(String key, String value) {
            try {
                this._locbld.setLDMLExtensionValue(key, value);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder clear() {
            this._locbld.clear();
            return this;
        }

        public Builder clearExtensions() {
            this._locbld.removeLocaleExtensions();
            return this;
        }

        public ULocale create() {
            return ULocale.getInstance(this._locbld.getBaseLocale(), this._locbld.getLocaleExtensions());
        }
    }

    public static final class Type {
        private Type() {
        }
    }

    private static final class IDParser {
        private char[] id;
        private int index;
        private char[] buffer;
        private int blen;
        private boolean canonicalize;
        private boolean hadCountry;
        Map keywords;
        String baseName;
        private static final char KEYWORD_SEPARATOR = '@';
        private static final char HYPHEN = '-';
        private static final char KEYWORD_ASSIGN = '=';
        private static final char COMMA = ',';
        private static final char ITEM_SEPARATOR = ';';
        private static final char DOT = '.';
        private static final char DONE = '\uffff';

        private IDParser(String localeID) {
            this(localeID, false);
        }

        private IDParser(String localeID, boolean canonicalize) {
            this.id = localeID.toCharArray();
            this.index = 0;
            this.buffer = new char[this.id.length + 5];
            this.blen = 0;
            this.canonicalize = canonicalize;
        }

        private void reset() {
            this.blen = 0;
            this.index = 0;
        }

        private void append(char c) {
            try {
                this.buffer[this.blen] = c;
            }
            catch (IndexOutOfBoundsException e) {
                if (this.buffer.length > 512) {
                    throw e;
                }
                char[] nbuffer = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, nbuffer, 0, this.buffer.length);
                nbuffer[this.blen] = c;
                this.buffer = nbuffer;
            }
            ++this.blen;
        }

        private void addSeparator() {
            this.append('_');
        }

        private String getString(int start) {
            if (start == this.blen) {
                return ULocale.EMPTY_STRING;
            }
            return new String(this.buffer, start, this.blen - start);
        }

        private void set(int pos, String s) {
            this.blen = pos;
            this.append(s);
        }

        private void append(String s) {
            for (int i = 0; i < s.length(); ++i) {
                this.append(s.charAt(i));
            }
        }

        private char next() {
            if (this.index == this.id.length) {
                ++this.index;
                return '\uffff';
            }
            return this.id[this.index++];
        }

        private void skipUntilTerminatorOrIDSeparator() {
            while (!this.isTerminatorOrIDSeparator(this.next())) {
            }
            --this.index;
        }

        private boolean atTerminator() {
            return this.index >= this.id.length || this.isTerminator(this.id[this.index]);
        }

        private boolean isTerminator(char c) {
            return c == '@' || c == '\uffff' || c == '.';
        }

        private boolean isTerminatorOrIDSeparator(char c) {
            return c == '@' || c == '_' || c == '-' || c == '\uffff' || c == '.';
        }

        private boolean haveExperimentalLanguagePrefix() {
            char c;
            if (this.id.length > 2 && ((c = this.id[1]) == '-' || c == '_')) {
                c = this.id[0];
                return c == 'x' || c == 'X' || c == 'i' || c == 'I';
            }
            return false;
        }

        private boolean haveKeywordAssign() {
            for (int i = this.index; i < this.id.length; ++i) {
                if (this.id[i] != '=') continue;
                return true;
            }
            return false;
        }

        private int parseLanguage() {
            char c;
            if (this.haveExperimentalLanguagePrefix()) {
                this.append(Character.toLowerCase(this.id[0]));
                this.append('-');
                this.index = 2;
            }
            while (!this.isTerminatorOrIDSeparator(c = this.next())) {
                this.append(Character.toLowerCase(c));
            }
            --this.index;
            if (this.blen == 3) {
                ULocale.initLanguageTables();
                String lang = this.getString(0);
                int offset = ULocale.findIndex(_languages3, lang);
                if (offset >= 0) {
                    this.set(0, _languages[offset]);
                } else {
                    offset = ULocale.findIndex(_obsoleteLanguages3, lang);
                    if (offset >= 0) {
                        this.set(0, _obsoleteLanguages[offset]);
                    }
                }
            }
            return 0;
        }

        private void skipLanguage() {
            if (this.haveExperimentalLanguagePrefix()) {
                this.index = 2;
            }
            this.skipUntilTerminatorOrIDSeparator();
        }

        private int parseScript() {
            if (!this.atTerminator()) {
                char c;
                int oldIndex = this.index++;
                int oldBlen = this.blen;
                while (!this.isTerminatorOrIDSeparator(c = this.next())) {
                    if (this.blen == oldBlen) {
                        this.addSeparator();
                        this.append(Character.toUpperCase(c));
                        continue;
                    }
                    this.append(Character.toLowerCase(c));
                }
                --this.index;
                if (this.index - oldIndex != 5) {
                    this.index = oldIndex;
                    this.blen = oldBlen;
                } else {
                    ++oldBlen;
                }
                return oldBlen;
            }
            return this.blen;
        }

        private void skipScript() {
            if (!this.atTerminator()) {
                int oldIndex = this.index++;
                this.skipUntilTerminatorOrIDSeparator();
                if (this.index - oldIndex != 5) {
                    this.index = oldIndex;
                }
            }
        }

        private int parseCountry() {
            if (!this.atTerminator()) {
                char c;
                int oldIndex = this.index++;
                int oldBlen = this.blen;
                while (!this.isTerminatorOrIDSeparator(c = this.next())) {
                    if (oldBlen == this.blen) {
                        this.hadCountry = true;
                        this.addSeparator();
                        ++oldBlen;
                    }
                    this.append(Character.toUpperCase(c));
                }
                --this.index;
                int charsAppended = this.blen - oldBlen;
                if (charsAppended != 0) {
                    if (charsAppended < 2 || charsAppended > 3) {
                        this.index = oldIndex;
                        this.blen = --oldBlen;
                        this.hadCountry = false;
                    } else if (charsAppended == 3) {
                        ULocale.initCountryTables();
                        int offset = ULocale.findIndex(_countries3, this.getString(oldBlen));
                        if (offset >= 0) {
                            this.set(oldBlen, _countries[offset]);
                        } else {
                            offset = ULocale.findIndex(_obsoleteCountries3, this.getString(oldBlen));
                            if (offset >= 0) {
                                this.set(oldBlen, _obsoleteCountries[offset]);
                            }
                        }
                    }
                }
                return oldBlen;
            }
            return this.blen;
        }

        private void skipCountry() {
            if (!this.atTerminator()) {
                ++this.index;
                int oldIndex = this.index;
                this.skipUntilTerminatorOrIDSeparator();
                int charsSkipped = this.index - oldIndex;
                if (charsSkipped < 2 || charsSkipped > 3) {
                    this.index = oldIndex;
                }
            }
        }

        private int parseVariant() {
            char c;
            int oldBlen = this.blen;
            boolean start = true;
            boolean needSeparator = true;
            boolean skipping = false;
            while ((c = this.next()) != '\uffff') {
                if (c == '.') {
                    start = false;
                    skipping = true;
                    continue;
                }
                if (c == '@') {
                    if (this.haveKeywordAssign()) break;
                    skipping = false;
                    start = false;
                    needSeparator = true;
                    continue;
                }
                if (start) {
                    start = false;
                    continue;
                }
                if (skipping) continue;
                if (needSeparator) {
                    boolean incOldBlen = this.blen == oldBlen;
                    needSeparator = false;
                    if (incOldBlen && !this.hadCountry) {
                        this.addSeparator();
                        ++oldBlen;
                    }
                    this.addSeparator();
                    if (incOldBlen) {
                        ++oldBlen;
                    }
                }
                if ((c = Character.toUpperCase(c)) == '-' || c == ',') {
                    c = '_';
                }
                this.append(c);
            }
            --this.index;
            return oldBlen;
        }

        public String getLanguage() {
            this.reset();
            return this.getString(this.parseLanguage());
        }

        public String getScript() {
            this.reset();
            this.skipLanguage();
            return this.getString(this.parseScript());
        }

        public String getCountry() {
            this.reset();
            this.skipLanguage();
            this.skipScript();
            return this.getString(this.parseCountry());
        }

        public String getVariant() {
            this.reset();
            this.skipLanguage();
            this.skipScript();
            this.skipCountry();
            return this.getString(this.parseVariant());
        }

        public String[] getLanguageScriptCountryVariant() {
            this.reset();
            return new String[]{this.getString(this.parseLanguage()), this.getString(this.parseScript()), this.getString(this.parseCountry()), this.getString(this.parseVariant())};
        }

        public void setBaseName(String baseName) {
            this.baseName = baseName;
        }

        public void parseBaseName() {
            if (this.baseName != null) {
                this.set(0, this.baseName);
            } else {
                this.reset();
                this.parseLanguage();
                this.parseScript();
                this.parseCountry();
                this.parseVariant();
                if (this.blen > 1 && this.buffer[this.blen - 1] == '_') {
                    --this.blen;
                }
            }
        }

        public String getBaseName() {
            if (this.baseName != null) {
                return this.baseName;
            }
            this.parseBaseName();
            return this.getString(0);
        }

        public String getName() {
            this.parseBaseName();
            this.parseKeywords();
            return this.getString(0);
        }

        private boolean setToKeywordStart() {
            for (int i = this.index; i < this.id.length; ++i) {
                if (this.id[i] != '@') continue;
                if (this.canonicalize) {
                    for (int j = ++i; j < this.id.length; ++j) {
                        if (this.id[j] != '=') continue;
                        this.index = i;
                        return true;
                    }
                    break;
                }
                if (++i >= this.id.length) break;
                this.index = i;
                return true;
            }
            return false;
        }

        private static boolean isDoneOrKeywordAssign(char c) {
            return c == '\uffff' || c == '=';
        }

        private static boolean isDoneOrItemSeparator(char c) {
            return c == '\uffff' || c == ';';
        }

        private String getKeyword() {
            int start = this.index;
            while (!IDParser.isDoneOrKeywordAssign(this.next())) {
            }
            --this.index;
            return AsciiUtil.toLowerString(new String(this.id, start, this.index - start).trim());
        }

        private String getValue() {
            int start = this.index;
            while (!IDParser.isDoneOrItemSeparator(this.next())) {
            }
            --this.index;
            return new String(this.id, start, this.index - start).trim();
        }

        private Comparator getKeyComparator() {
            Comparator comp = new Comparator(){

                public int compare(Object lhs, Object rhs) {
                    return ((String)lhs).compareTo((String)rhs);
                }
            };
            return comp;
        }

        private Map getKeywordMap() {
            block6: {
                TreeMap<String, String> m;
                block7: {
                    String key;
                    if (this.keywords != null) break block6;
                    m = null;
                    if (!this.setToKeywordStart()) break block7;
                    while ((key = this.getKeyword()).length() != 0) {
                        block9: {
                            String value;
                            block11: {
                                block10: {
                                    block8: {
                                        char c = this.next();
                                        if (c == '=') break block8;
                                        if (c == '\uffff') {
                                            break;
                                        }
                                        break block9;
                                    }
                                    value = this.getValue();
                                    if (value.length() == 0) break block9;
                                    if (m != null) break block10;
                                    m = new TreeMap<String, String>(this.getKeyComparator());
                                    break block11;
                                }
                                if (m.containsKey(key)) break block9;
                            }
                            m.put(key, value);
                        }
                        if (this.next() == ';') continue;
                    }
                }
                this.keywords = m != null ? m : Collections.EMPTY_MAP;
            }
            return this.keywords;
        }

        private int parseKeywords() {
            int oldBlen = this.blen;
            Map m = this.getKeywordMap();
            if (!m.isEmpty()) {
                Iterator iter = m.entrySet().iterator();
                boolean first = true;
                while (iter.hasNext()) {
                    this.append(first ? (char)'@' : ';');
                    first = false;
                    Map.Entry e = iter.next();
                    this.append((String)e.getKey());
                    this.append('=');
                    this.append((String)e.getValue());
                }
                if (this.blen != oldBlen) {
                    ++oldBlen;
                }
            }
            return oldBlen;
        }

        public Iterator getKeywords() {
            Map m = this.getKeywordMap();
            return m.isEmpty() ? null : m.keySet().iterator();
        }

        public String getKeywordValue(String keywordName) {
            Map m = this.getKeywordMap();
            return m.isEmpty() ? null : (String)m.get(AsciiUtil.toLowerString(keywordName.trim()));
        }

        public void defaultKeywordValue(String keywordName, String value) {
            this.setKeywordValue(keywordName, value, false);
        }

        public void setKeywordValue(String keywordName, String value) {
            this.setKeywordValue(keywordName, value, true);
        }

        private void setKeywordValue(String keywordName, String value, boolean reset) {
            if (keywordName == null) {
                if (reset) {
                    this.keywords = Collections.EMPTY_MAP;
                }
            } else {
                if ((keywordName = AsciiUtil.toLowerString(keywordName.trim())).length() == 0) {
                    throw new IllegalArgumentException("keyword must not be empty");
                }
                if (value != null && (value = value.trim()).length() == 0) {
                    throw new IllegalArgumentException("value must not be empty");
                }
                Map m = this.getKeywordMap();
                if (m.isEmpty()) {
                    if (value != null) {
                        this.keywords = new TreeMap(this.getKeyComparator());
                        this.keywords.put(keywordName, value.trim());
                    }
                } else if (reset || !m.containsKey(keywordName)) {
                    if (value != null) {
                        m.put(keywordName, value);
                    } else {
                        m.remove(keywordName);
                        if (m.isEmpty()) {
                            this.keywords = Collections.EMPTY_MAP;
                        }
                    }
                }
            }
        }
    }
}

