/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUCache;
import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.impl.TextTrieMap;
import com.ibm.icu.util.MeasureUnit;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.Serializable;
import java.text.ChoiceFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;

public class Currency
extends MeasureUnit
implements Serializable {
    private static final long serialVersionUID = -5839973855554750484L;
    private static final boolean DEBUG = ICUDebug.enabled("currency");
    private static ICUCache CURRENCY_NAME_CACHE = new SimpleCache();
    private String isoCode;
    public static final int SYMBOL_NAME = 0;
    public static final int LONG_NAME = 1;
    public static final int PLURAL_LONG_NAME = 2;
    private static ServiceShim shim;
    private static final String EUR_STR = "EUR";
    private static final int[] LAST_RESORT_DATA;
    private static final int[] POW10;
    private ULocale validLocale;
    private ULocale actualLocale;

    private static ServiceShim getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName("com.ibm.icu.util.CurrencyServiceShim");
                shim = (ServiceShim)cls.newInstance();
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return shim;
    }

    public static Currency getInstance(Locale locale) {
        return Currency.getInstance(ULocale.forLocale(locale));
    }

    public static Currency getInstance(ULocale locale) {
        String currency = locale.getKeywordValue("currency");
        if (currency != null) {
            return Currency.getInstance(currency);
        }
        if (shim == null) {
            return Currency.createCurrency(locale);
        }
        return shim.createInstance(locale);
    }

    public static String[] getAvailableCurrencyCodes(ULocale loc, Date d) {
        String country = loc.getCountry();
        long dateL = d.getTime();
        long mask = 0xFFFFFFFFL;
        Vector<String> currCodeVector = new Vector<String>();
        ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        if (bundle == null) {
            return null;
        }
        try {
            UResourceBundle cm = bundle.get("CurrencyMap");
            UResourceBundle countryArray = cm.get(country);
            for (int i = 0; i < countryArray.getSize(); ++i) {
                UResourceBundle currencyReq = countryArray.get(i);
                String curriso = null;
                curriso = currencyReq.getString("id");
                long fromDate = 0L;
                UResourceBundle fromRes = currencyReq.get("from");
                int[] fromArray = fromRes.getIntVector();
                fromDate = (long)fromArray[0] << 32;
                fromDate |= (long)fromArray[1] & mask;
                if (currencyReq.getSize() > 2) {
                    long toDate = 0L;
                    UResourceBundle toRes = currencyReq.get("to");
                    int[] toArray = toRes.getIntVector();
                    toDate = (long)toArray[0] << 32;
                    if (fromDate > dateL || dateL >= (toDate |= (long)toArray[1] & mask)) continue;
                    currCodeVector.addElement(curriso);
                    continue;
                }
                if (fromDate > dateL) continue;
                currCodeVector.addElement(curriso);
            }
            currCodeVector.trimToSize();
            if (currCodeVector.size() != 0) {
                return currCodeVector.toArray(new String[0]);
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return null;
    }

    static Currency createCurrency(ULocale loc) {
        String country = loc.getCountry();
        String variant = loc.getVariant();
        boolean isPreEuro = variant.equals("PREEURO");
        boolean isEuro = variant.equals("EURO");
        ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        if (bundle == null) {
            return null;
        }
        try {
            UResourceBundle cm = bundle.get("CurrencyMap");
            String curriso = null;
            UResourceBundle countryArray = cm.get(country);
            UResourceBundle currencyReq = countryArray.get(0);
            curriso = currencyReq.getString("id");
            if (isPreEuro && curriso.equals(EUR_STR)) {
                currencyReq = countryArray.get(1);
                curriso = currencyReq.getString("id");
            } else if (isEuro) {
                curriso = EUR_STR;
            }
            if (curriso != null) {
                return new Currency(curriso);
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return null;
    }

    public static Currency getInstance(String theISOCode) {
        if (theISOCode == null) {
            throw new NullPointerException("The input currency code is null.");
        }
        boolean is3alpha = true;
        if (theISOCode.length() != 3) {
            is3alpha = false;
        } else {
            for (int i = 0; i < 3; ++i) {
                char ch = theISOCode.charAt(i);
                if (ch >= 'A' && (ch <= 'Z' || ch >= 'a') && ch <= 'z') continue;
                is3alpha = false;
                break;
            }
        }
        if (!is3alpha) {
            throw new IllegalArgumentException("The input currency code is not 3-letter alphabetic code.");
        }
        return new Currency(theISOCode.toUpperCase(Locale.US));
    }

    public static Object registerInstance(Currency currency, ULocale locale) {
        return Currency.getShim().registerInstance(currency, locale);
    }

    public static boolean unregister(Object registryKey) {
        if (registryKey == null) {
            throw new IllegalArgumentException("registryKey must not be null");
        }
        if (shim == null) {
            return false;
        }
        return shim.unregister(registryKey);
    }

    public static Locale[] getAvailableLocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableLocales("com/ibm/icu/impl/data/icudt42b");
        }
        return shim.getAvailableLocales();
    }

    public static ULocale[] getAvailableULocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableULocales("com/ibm/icu/impl/data/icudt42b");
        }
        return shim.getAvailableULocales();
    }

    public static final String[] getKeywordValuesForLocale(String key, ULocale locale, boolean commonlyUsed) {
        String prefRegion = locale.getCountry();
        if (prefRegion.length() == 0) {
            ULocale loc = ULocale.addLikelySubtags(locale);
            prefRegion = loc.getCountry();
        }
        LinkedList<String> values = new LinkedList<String>();
        LinkedList<String> otherValues = new LinkedList<String>();
        UResourceBundle bundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", "supplementalData");
        bundle = bundle.get("CurrencyMap");
        Enumeration keyEnum = bundle.getKeys();
        boolean done = false;
        while (keyEnum.hasMoreElements() && !done) {
            String region = (String)keyEnum.nextElement();
            boolean isPrefRegion = prefRegion.equals(region);
            if (!isPrefRegion && commonlyUsed) continue;
            UResourceBundle regbndl = bundle.get(region);
            for (int i = 0; i < regbndl.getSize(); ++i) {
                UResourceBundle curbndl = regbndl.get(i);
                if (curbndl.getType() != 2) continue;
                String curID = curbndl.getString("id");
                boolean hasTo = false;
                try {
                    UResourceBundle to = curbndl.get("to");
                    if (to != null) {
                        hasTo = true;
                    }
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
                if (isPrefRegion && !hasTo && !values.contains(curID)) {
                    values.add(curID);
                    continue;
                }
                if (otherValues.contains(curID) || commonlyUsed) continue;
                otherValues.add(curID);
            }
        }
        if (commonlyUsed) {
            if (values.size() == 0) {
                return Currency.getKeywordValuesForLocale(key, new ULocale("und"), true);
            }
        } else {
            Iterator itr = otherValues.iterator();
            while (itr.hasNext()) {
                String curID = (String)itr.next();
                if (values.contains(curID)) continue;
                values.add(curID);
            }
        }
        return values.toArray(new String[values.size()]);
    }

    public int hashCode() {
        return this.isoCode.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        try {
            Currency c = (Currency)rhs;
            return this.isoCode.equals(c.isoCode);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String getCurrencyCode() {
        return this.isoCode;
    }

    public String getSymbol() {
        return this.getSymbol(ULocale.getDefault());
    }

    public String getSymbol(Locale loc) {
        return this.getSymbol(ULocale.forLocale(loc));
    }

    public String getSymbol(ULocale uloc) {
        return this.getName(uloc, 0, new boolean[1]);
    }

    public String getName(Locale locale, int nameStyle, boolean[] isChoiceFormat) {
        return this.getName(ULocale.forLocale(locale), nameStyle, isChoiceFormat);
    }

    public String getName(ULocale locale, int nameStyle, boolean[] isChoiceFormat) {
        if (nameStyle < 0 || nameStyle > 1) {
            throw new IllegalArgumentException();
        }
        String s = null;
        try {
            UResourceBundle rb = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", locale);
            ICUResourceBundle currencies = (ICUResourceBundle)rb.get("Currencies");
            s = currencies.getWithFallback(this.isoCode).getString(nameStyle);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        isChoiceFormat[0] = false;
        if (s != null) {
            int i;
            for (i = 0; i < s.length() && s.charAt(i) == '=' && i < 2; ++i) {
            }
            boolean bl = isChoiceFormat[0] = i == 1;
            if (i != 0) {
                s = s.substring(1);
            }
            return s;
        }
        return this.isoCode;
    }

    public String getName(Locale locale, int nameStyle, String pluralCount, boolean[] isChoiceFormat) {
        return this.getName(ULocale.forLocale(locale), nameStyle, pluralCount, isChoiceFormat);
    }

    public String getName(ULocale locale, int nameStyle, String pluralCount, boolean[] isChoiceFormat) {
        ICUResourceBundle isoCodeBundle;
        if (nameStyle != 2) {
            return this.getName(locale, nameStyle, isChoiceFormat);
        }
        String s = null;
        try {
            UResourceBundle rb = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", locale);
            ICUResourceBundle currencies = (ICUResourceBundle)rb.get("CurrencyPlurals");
            isoCodeBundle = currencies.getWithFallback(this.isoCode);
        }
        catch (MissingResourceException e) {
            return this.getName(locale, 1, isChoiceFormat);
        }
        try {
            s = isoCodeBundle.getStringWithFallback(pluralCount);
        }
        catch (MissingResourceException e1) {
            try {
                s = isoCodeBundle.getStringWithFallback("other");
            }
            catch (MissingResourceException e) {
                return this.getName(locale, 1, isChoiceFormat);
            }
        }
        if (s != null) {
            return s;
        }
        return this.isoCode;
    }

    public static String parse(ULocale locale, String text, int type, ParsePosition pos) {
        Vector<TextTrieMap> currencyTrieVec = (Vector<TextTrieMap>)CURRENCY_NAME_CACHE.get(locale);
        if (currencyTrieVec == null) {
            TextTrieMap currencyNameTrie = new TextTrieMap(true);
            TextTrieMap currencySymbolTrie = new TextTrieMap(false);
            currencyTrieVec = new Vector<TextTrieMap>();
            currencyTrieVec.addElement(currencySymbolTrie);
            currencyTrieVec.addElement(currencyNameTrie);
            Currency.setupCurrencyTrieVec(locale, currencyTrieVec);
            CURRENCY_NAME_CACHE.put(locale, currencyTrieVec);
        }
        int maxLength = 0;
        String isoResult = null;
        TextTrieMap currencyNameTrie = (TextTrieMap)currencyTrieVec.elementAt(1);
        CurrencyNameResultHandler handler = new CurrencyNameResultHandler();
        currencyNameTrie.find(text, pos.getIndex(), handler);
        List list = handler.getMatchedCurrencyNames();
        if (list != null && list.size() != 0) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                CurrencyStringInfo info = (CurrencyStringInfo)it.next();
                String isoCode = info.getISOCode();
                String currencyString = info.getCurrencyString();
                if (currencyString.length() <= maxLength) continue;
                maxLength = currencyString.length();
                isoResult = isoCode;
            }
        }
        if (type != 1) {
            TextTrieMap currencySymbolTrie = (TextTrieMap)currencyTrieVec.elementAt(0);
            handler = new CurrencyNameResultHandler();
            currencySymbolTrie.find(text, pos.getIndex(), handler);
            list = handler.getMatchedCurrencyNames();
            if (list != null && list.size() != 0) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    CurrencyStringInfo info = (CurrencyStringInfo)it.next();
                    String isoCode = info.getISOCode();
                    String currencyString = info.getCurrencyString();
                    if (currencyString.length() <= maxLength) continue;
                    maxLength = currencyString.length();
                    isoResult = isoCode;
                }
            }
        }
        int start = pos.getIndex();
        pos.setIndex(start + maxLength);
        return isoResult;
    }

    private static void setupCurrencyTrieVec(ULocale locale, Vector trieVec) {
        ULocale parentLocale;
        TextTrieMap symTrie = (TextTrieMap)trieVec.elementAt(0);
        TextTrieMap trie = (TextTrieMap)trieVec.elementAt(1);
        HashSet<String> visited = new HashSet<String>();
        for (parentLocale = locale; parentLocale != null; parentLocale = parentLocale.getFallback()) {
            UResourceBundle rb = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", parentLocale);
            try {
                UResourceBundle currencies = rb.get("Currencies");
                for (int i = 0; i < currencies.getSize(); ++i) {
                    UResourceBundle item = currencies.get(i);
                    String ISOCode = item.getKey();
                    if (visited.contains(ISOCode)) continue;
                    CurrencyStringInfo info = new CurrencyStringInfo(ISOCode, ISOCode);
                    symTrie.put(ISOCode, info);
                    String name = item.getString(0);
                    if (name.length() > 1 && name.charAt(0) == '=' && name.charAt(1) != '=') {
                        name = name.substring(1);
                        ChoiceFormat choice = new ChoiceFormat(name);
                        Object[] names = choice.getFormats();
                        for (int nameIndex = 0; nameIndex < names.length; ++nameIndex) {
                            info = new CurrencyStringInfo(ISOCode, (String)names[nameIndex]);
                            symTrie.put((String)names[nameIndex], info);
                        }
                    } else {
                        info = new CurrencyStringInfo(ISOCode, name);
                        symTrie.put(name, info);
                    }
                    info = new CurrencyStringInfo(ISOCode, item.getString(1));
                    trie.put(item.getString(1), info);
                    visited.add(ISOCode);
                }
                continue;
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        HashMap visitedInMap = new HashMap();
        for (parentLocale = locale; parentLocale != null; parentLocale = parentLocale.getFallback()) {
            UResourceBundle rb = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", parentLocale);
            try {
                UResourceBundle currencies = rb.get("CurrencyPlurals");
                for (int i = 0; i < currencies.getSize(); ++i) {
                    UResourceBundle item = currencies.get(i);
                    String ISOCode = item.getKey();
                    HashSet<String> visitPluralCount = (HashSet<String>)visitedInMap.get(ISOCode);
                    if (visitPluralCount == null) {
                        visitPluralCount = new HashSet<String>();
                        visitedInMap.put(ISOCode, visitPluralCount);
                    }
                    for (int j = 0; j < item.getSize(); ++j) {
                        String count = item.get(j).getKey();
                        if (visitPluralCount.contains(count)) continue;
                        CurrencyStringInfo info = new CurrencyStringInfo(ISOCode, item.get(j).getString());
                        trie.put(item.get(j).getString(), info);
                        visitPluralCount.add(count);
                    }
                }
                continue;
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
    }

    public int getDefaultFractionDigits() {
        return this.findData()[0];
    }

    public double getRoundingIncrement() {
        int[] data = this.findData();
        int data1 = data[1];
        if (data1 == 0) {
            return 0.0;
        }
        int data0 = data[0];
        if (data0 < 0 || data0 >= POW10.length) {
            return 0.0;
        }
        return (double)data1 / (double)POW10[data0];
    }

    public String toString() {
        return this.isoCode;
    }

    protected Currency(String theISOCode) {
        this.isoCode = theISOCode;
    }

    private int[] findData() {
        try {
            UResourceBundle root = ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle currencyMeta = root.get("CurrencyMeta");
            int[] i = currencyMeta.get(this.isoCode).getIntVector();
            if (i == null) {
                i = currencyMeta.get("DEFAULT").getIntVector();
            }
            if (i != null && i.length >= 2) {
                return i;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return LAST_RESORT_DATA;
    }

    public final ULocale getLocale(ULocale.Type type) {
        ULocale result;
        ULocale uLocale = result = type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
        if (result == null) {
            return ULocale.ROOT;
        }
        return result;
    }

    final void setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }

    static {
        LAST_RESORT_DATA = new int[]{2, 0};
        POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }

    private static class CurrencyNameResultHandler
    implements TextTrieMap.ResultHandler {
        private ArrayList resultList;

        private CurrencyNameResultHandler() {
        }

        public boolean handlePrefixMatch(int matchLength, Iterator values) {
            CurrencyStringInfo item;
            if (this.resultList == null) {
                this.resultList = new ArrayList();
            }
            while (values.hasNext() && (item = (CurrencyStringInfo)values.next()) != null) {
                int i;
                for (i = 0; i < this.resultList.size(); ++i) {
                    CurrencyStringInfo tmp = (CurrencyStringInfo)this.resultList.get(i);
                    if (item.getISOCode() != tmp.getISOCode()) continue;
                    if (matchLength <= tmp.getCurrencyString().length()) break;
                    this.resultList.set(i, item);
                    break;
                }
                if (i != this.resultList.size()) continue;
                this.resultList.add(item);
            }
            return true;
        }

        List getMatchedCurrencyNames() {
            if (this.resultList == null || this.resultList.size() == 0) {
                return null;
            }
            return this.resultList;
        }
    }

    private static final class CurrencyStringInfo {
        private String isoCode;
        private String currencyString;

        public CurrencyStringInfo(String isoCode, String currencyString) {
            this.isoCode = isoCode;
            this.currencyString = currencyString;
        }

        private String getISOCode() {
            return this.isoCode;
        }

        private String getCurrencyString() {
            return this.currencyString;
        }
    }

    static abstract class ServiceShim {
        ServiceShim() {
        }

        abstract ULocale[] getAvailableULocales();

        abstract Locale[] getAvailableLocales();

        abstract Currency createInstance(ULocale var1);

        abstract Object registerInstance(Currency var1, ULocale var2);

        abstract boolean unregister(Object var1);
    }
}

