/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.CollectionUtilities;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.LocaleData;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class IndexCharacters {
    public static final char CGJ = '\u034f';
    private static final UnicodeSet ALPHABETIC = new UnicodeSet("[[:alphabetic:]-[:mark:]]");
    private static final UnicodeSet HANGUL = new UnicodeSet("[\uac00 \ub098 \ub2e4 \ub77c \ub9c8 \ubc14  \uc0ac  \uc544 \uc790  \ucc28 \uce74 \ud0c0 \ud30c \ud558]");
    private static final UnicodeSet ETHIOPIC = new UnicodeSet("[[:Block=Ethiopic:]&[:Script=Ethiopic:]]");
    private static final UnicodeSet CORE_LATIN = new UnicodeSet("[a-z]");
    private ULocale locale;
    private Collator comparator;
    private Set indexCharacters;
    private LinkedHashMap alreadyIn = new LinkedHashMap();
    private List noDistinctSorting = new ArrayList();
    private List notAlphabetic = new ArrayList();

    public IndexCharacters(ULocale locale) {
        this.locale = locale;
        this.comparator = Collator.getInstance(locale);
        this.comparator.setStrength(0);
        UnicodeSet exemplars = LocaleData.getExemplarSet(locale, 0);
        if (exemplars.containsSome(CORE_LATIN)) {
            exemplars.addAll(CORE_LATIN);
        }
        if (exemplars.containsSome(HANGUL)) {
            exemplars.removeAll(new UnicodeSet("[:block=hangul_syllables:]")).addAll(HANGUL);
        }
        if (exemplars.containsSome(ETHIOPIC)) {
            UnicodeSetIterator it = new UnicodeSetIterator(ETHIOPIC);
            while (it.next()) {
                if ((it.codepoint & 7) == 0) continue;
                exemplars.remove(it.codepoint);
            }
        }
        TreeSet<String> preferenceSorting = new TreeSet<String>(new CollectionUtilities.MultiComparator(new Comparator[]{this.comparator, new PreferenceComparator(Collator.getInstance(locale))}));
        Object it = new UnicodeSetIterator(exemplars);
        while (((UnicodeSetIterator)it).next()) {
            preferenceSorting.add(((UnicodeSetIterator)it).getString());
        }
        this.indexCharacters = new TreeSet(this.comparator);
        it = preferenceSorting.iterator();
        block2: while (it.hasNext()) {
            String item = (String)it.next();
            if (this.indexCharacters.contains(item = UCharacter.toUpperCase(locale, item))) {
                Iterator it2 = this.indexCharacters.iterator();
                while (it2.hasNext()) {
                    Object itemAlreadyIn = it2.next();
                    if (this.comparator.compare((Object)item, itemAlreadyIn) != 0) continue;
                    LinkedHashSet<String> targets = (LinkedHashSet<String>)this.alreadyIn.get(itemAlreadyIn);
                    if (targets == null) {
                        targets = new LinkedHashSet<String>();
                        this.alreadyIn.put(itemAlreadyIn, targets);
                    }
                    targets.add(item);
                    continue block2;
                }
                continue;
            }
            if (UTF16.countCodePoint(item) > 1 && this.comparator.compare(item, this.separated(item)) == 0) {
                this.noDistinctSorting.add(item);
                continue;
            }
            if (!ALPHABETIC.containsSome(item)) {
                this.notAlphabetic.add(item);
                continue;
            }
            this.indexCharacters.add(item);
        }
        int size = this.indexCharacters.size() - 1;
        if (size > 99) {
            int count = 0;
            int old = -1;
            Iterator it2 = this.indexCharacters.iterator();
            while (it2.hasNext()) {
                it2.next();
                int bump = ++count * 99 / size;
                if (bump == old) {
                    it2.remove();
                    continue;
                }
                old = bump;
            }
        }
        this.indexCharacters = Collections.unmodifiableSet(this.indexCharacters);
    }

    private String separated(String item) {
        StringBuffer result = new StringBuffer();
        char last = item.charAt(0);
        result.append(last);
        for (int i = 1; i < item.length(); ++i) {
            char ch = item.charAt(i);
            if (!UCharacter.isHighSurrogate(last) || !UCharacter.isLowSurrogate(ch)) {
                result.append('\u034f');
            }
            result.append(ch);
            last = ch;
        }
        return result.toString();
    }

    public Collection getIndexCharacters() {
        return this.indexCharacters;
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public Map getAlreadyIn() {
        return this.alreadyIn;
    }

    public List getNoDistinctSorting() {
        return this.noDistinctSorting;
    }

    public List getNotAlphabetic() {
        return this.notAlphabetic;
    }

    private static class PreferenceComparator
    implements Comparator {
        static final Comparator binary = new UTF16.StringComparator(true, false, 0);
        final Collator collator;

        public PreferenceComparator(Collator collator) {
            this.collator = collator;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            String s1 = (String)o1;
            String s2 = (String)o2;
            String n1 = Normalizer.decompose(s1, true);
            String n2 = Normalizer.decompose(s2, true);
            int result = n1.length() - n2.length();
            if (result != 0) {
                return result;
            }
            result = this.collator.compare(n1, n2);
            if (result != 0) {
                return result;
            }
            return binary.compare(s1, s2);
        }
    }
}

