/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

public class CurrencyPluralInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final char[] tripleCurrencySign = new char[]{'\u00a4', '\u00a4', '\u00a4'};
    private static final String tripleCurrencyStr = new String(tripleCurrencySign);
    private static final char[] defaultCurrencyPluralPatternChar = new char[]{'\u0000', '.', '#', '#', ' ', '\u00a4', '\u00a4', '\u00a4'};
    private static final String defaultCurrencyPluralPattern = new String(defaultCurrencyPluralPatternChar);
    private Map pluralCountToCurrencyUnitPattern = null;
    private PluralRules pluralRules = null;
    private ULocale ulocale = null;

    public CurrencyPluralInfo() {
        this.initialize(ULocale.getDefault());
    }

    public CurrencyPluralInfo(Locale locale) {
        this.initialize(ULocale.forLocale(locale));
    }

    public CurrencyPluralInfo(ULocale locale) {
        this.initialize(locale);
    }

    public static CurrencyPluralInfo getInstance() {
        return new CurrencyPluralInfo();
    }

    public static CurrencyPluralInfo getInstance(Locale locale) {
        return new CurrencyPluralInfo(locale);
    }

    public static CurrencyPluralInfo getInstance(ULocale locale) {
        return new CurrencyPluralInfo(locale);
    }

    public PluralRules getPluralRules() {
        return this.pluralRules;
    }

    public String getCurrencyPluralPattern(String pluralCount) {
        String currencyPluralPattern = (String)this.pluralCountToCurrencyUnitPattern.get(pluralCount);
        if (currencyPluralPattern == null) {
            if (!pluralCount.equals("other")) {
                currencyPluralPattern = (String)this.pluralCountToCurrencyUnitPattern.get("other");
            }
            if (currencyPluralPattern == null) {
                currencyPluralPattern = defaultCurrencyPluralPattern;
            }
        }
        return currencyPluralPattern;
    }

    public ULocale getLocale() {
        return this.ulocale;
    }

    public void setPluralRules(String ruleDescription) {
        this.pluralRules = PluralRules.createRules(ruleDescription);
    }

    public void setCurrencyPluralPattern(String pluralCount, String pattern) {
        this.pluralCountToCurrencyUnitPattern.put(pluralCount, pattern);
    }

    public void setLocale(ULocale loc) {
        this.ulocale = loc;
        this.initialize(loc);
    }

    public Object clone() {
        try {
            CurrencyPluralInfo other = (CurrencyPluralInfo)super.clone();
            other.ulocale = (ULocale)this.ulocale.clone();
            other.pluralCountToCurrencyUnitPattern = new HashMap();
            Iterator iter = this.pluralCountToCurrencyUnitPattern.keySet().iterator();
            while (iter.hasNext()) {
                String pluralCount = (String)iter.next();
                String currencyPattern = (String)this.pluralCountToCurrencyUnitPattern.get(pluralCount);
                other.pluralCountToCurrencyUnitPattern.put(pluralCount, currencyPattern);
            }
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object a) {
        if (a instanceof CurrencyPluralInfo) {
            CurrencyPluralInfo other = (CurrencyPluralInfo)a;
            return this.pluralRules.equals(other.pluralRules) && ((Object)this.pluralCountToCurrencyUnitPattern).equals(other.pluralCountToCurrencyUnitPattern);
        }
        return false;
    }

    String select(double number) {
        return this.pluralRules.select(number);
    }

    Iterator pluralPatternIterator() {
        return this.pluralCountToCurrencyUnitPattern.keySet().iterator();
    }

    private void initialize(ULocale uloc) {
        this.ulocale = uloc;
        this.pluralRules = PluralRules.forLocale(uloc);
        this.setupCurrencyPluralPattern(uloc);
    }

    private void setupCurrencyPluralPattern(ULocale uloc) {
        this.pluralCountToCurrencyUnitPattern = new HashMap();
        HashSet<String> pluralCountSet = new HashSet<String>();
        ULocale parentLocale = uloc;
        String numberStylePattern = NumberFormat.getPattern(uloc, 0);
        int separatorIndex = numberStylePattern.indexOf(";");
        String negNumberPattern = null;
        if (separatorIndex != -1) {
            negNumberPattern = numberStylePattern.substring(separatorIndex + 1);
            numberStylePattern = numberStylePattern.substring(0, separatorIndex);
        }
        while (parentLocale != null) {
            try {
                ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", parentLocale);
                ICUResourceBundle currencyRes = resource.getWithFallback("CurrencyUnitPatterns");
                int size = currencyRes.getSize();
                for (int index = 0; index < size; ++index) {
                    String pluralCount = currencyRes.get(index).getKey();
                    if (pluralCountSet.contains(pluralCount)) continue;
                    String pattern = currencyRes.get(index).getString();
                    String patternWithNumber = Utility.replace(pattern, "{0}", numberStylePattern);
                    String patternWithCurrencySign = Utility.replace(patternWithNumber, "{1}", tripleCurrencyStr);
                    if (separatorIndex != -1) {
                        String negPattern = pattern;
                        String negWithNumber = Utility.replace(negPattern, "{0}", negNumberPattern);
                        String negWithCurrSign = Utility.replace(negWithNumber, "{1}", tripleCurrencyStr);
                        StringBuffer posNegPatterns = new StringBuffer(patternWithCurrencySign);
                        posNegPatterns.append(";");
                        posNegPatterns.append(negWithCurrSign);
                        patternWithCurrencySign = posNegPatterns.toString();
                    }
                    this.pluralCountToCurrencyUnitPattern.put(pluralCount, patternWithCurrencySign);
                    pluralCountSet.add(pluralCount);
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            parentLocale = parentLocale.getFallback();
        }
    }
}

