/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.text.StringTransform;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Freezable;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class UnicodeRegex
implements Cloneable,
Freezable,
StringTransform {
    private static UnicodeRegex STANDARD = new UnicodeRegex();
    private String bnfCommentString = "#";
    private String bnfVariableInfix = "=";
    private String bnfLineSeparator = "\n";
    private Appendable log = null;
    private Comparator LongestFirst = new Comparator(){

        public int compare(Object obj0, Object obj1) {
            int len1;
            String arg0 = obj0.toString();
            String arg1 = obj1.toString();
            int len0 = arg0.length();
            if (len0 != (len1 = arg1.length())) {
                return len1 - len0;
            }
            return arg0.compareTo(arg1);
        }
    };

    /*
     * Enabled aggressive block sorting
     */
    public String transform(String regex) {
        StringBuffer result = new StringBuffer();
        UnicodeSet temp = new UnicodeSet();
        ParsePosition pos = new ParsePosition(0);
        int state = 0;
        int i = 0;
        while (true) {
            block13: {
                if (i >= regex.length()) {
                    return result.toString();
                }
                char ch = regex.charAt(i);
                switch (state) {
                    case 0: {
                        if (ch == '\\') {
                            if (UnicodeSet.resemblesPattern(regex, i)) {
                                i = this.processSet(regex, i, result, temp, pos);
                                break block13;
                            } else {
                                state = 1;
                                break;
                            }
                        }
                        if (ch != '[' || !UnicodeSet.resemblesPattern(regex, i)) break;
                        i = this.processSet(regex, i, result, temp, pos);
                        break block13;
                    }
                    case 1: {
                        if (ch == 'Q') {
                            state = 1;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 2: {
                        if (ch != '\\') break;
                        state = 3;
                        break;
                    }
                    case 3: {
                        if (ch == 'E') {
                            state = 0;
                        }
                        state = 2;
                    }
                }
                result.append(ch);
            }
            ++i;
        }
    }

    public static String fix(String regex) {
        return STANDARD.transform(regex);
    }

    public static Pattern compile(String regex) {
        return Pattern.compile(STANDARD.transform(regex));
    }

    public static Pattern compile(String regex, int options) {
        return Pattern.compile(STANDARD.transform(regex), options);
    }

    public String compileBnf(String bnfLines) {
        return this.compileBnf(Arrays.asList(bnfLines.split("\\r\\n?|\\n")));
    }

    public String compileBnf(List lines) {
        Map variables = this.getVariables(lines);
        LinkedHashSet unused = new LinkedHashSet(variables.keySet());
        for (int i = 0; i < 2; ++i) {
            Iterator it = variables.keySet().iterator();
            while (it.hasNext()) {
                String variable = (String)it.next();
                String definition = (String)variables.get(variable);
                Iterator it2 = variables.keySet().iterator();
                while (it2.hasNext()) {
                    String definition2;
                    String altered2;
                    String variable2 = (String)it2.next();
                    if (variable.equals(variable2) || (altered2 = (definition2 = (String)variables.get(variable2)).replace(variable, definition)).equals(definition2)) continue;
                    unused.remove(variable);
                    variables.put(variable2, altered2);
                    if (this.log == null) continue;
                    try {
                        this.log.append(variable2 + "=" + altered2 + ";");
                    }
                    catch (IOException e) {
                        throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
                    }
                }
            }
        }
        if (unused.size() != 1) {
            throw new IllegalArgumentException("Not a single root: " + unused);
        }
        return (String)variables.get(unused.iterator().next());
    }

    public String getBnfCommentString() {
        return this.bnfCommentString;
    }

    public void setBnfCommentString(String bnfCommentString) {
        this.bnfCommentString = bnfCommentString;
    }

    public String getBnfVariableInfix() {
        return this.bnfVariableInfix;
    }

    public void setBnfVariableInfix(String bnfVariableInfix) {
        this.bnfVariableInfix = bnfVariableInfix;
    }

    public String getBnfLineSeparator() {
        return this.bnfLineSeparator;
    }

    public void setBnfLineSeparator(String bnfLineSeparator) {
        this.bnfLineSeparator = bnfLineSeparator;
    }

    public static List appendLines(List result, String file, String encoding) throws IOException {
        return UnicodeRegex.appendLines(result, new FileInputStream(file), encoding);
    }

    public static List appendLines(List result, InputStream inputStream, String encoding) throws UnsupportedEncodingException, IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, encoding == null ? "UTF-8" : encoding));
        while ((line = in.readLine()) != null) {
            result.add(line);
        }
        return result;
    }

    public Object cloneAsThawed() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException();
        }
    }

    public Object freeze() {
        return this;
    }

    public boolean isFrozen() {
        return true;
    }

    private int processSet(String regex, int i, StringBuffer result, UnicodeSet temp, ParsePosition pos) {
        try {
            pos.setIndex(i);
            UnicodeSet x = temp.clear().applyPattern(regex, pos, null, 0);
            x.complement().complement();
            result.append(x.toPattern(false));
            i = pos.getIndex() - 1;
            return i;
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Error in " + regex).initCause(e);
        }
    }

    private Map getVariables(List lines) {
        TreeMap<String, String> variables = new TreeMap<String, String>(this.LongestFirst);
        String variable = null;
        StringBuffer definition = new StringBuffer();
        int count = 0;
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            int equalsPos;
            String linePart;
            String trimline;
            int hashPos;
            String line = (String)it.next();
            ++count;
            if (line.length() == 0) continue;
            if (line.charAt(0) == '\ufeff') {
                line = line.substring(1);
            }
            if (this.bnfCommentString != null && (hashPos = line.indexOf(this.bnfCommentString)) >= 0) {
                line = line.substring(0, hashPos);
            }
            if ((trimline = line.trim()).length() == 0 || (linePart = line).trim().length() == 0) continue;
            boolean terminated = trimline.endsWith(";");
            if (terminated) {
                linePart = linePart.substring(0, linePart.lastIndexOf(59));
            }
            if ((equalsPos = linePart.indexOf(this.bnfVariableInfix)) >= 0) {
                if (variable != null) {
                    throw new IllegalArgumentException("Missing ';' before " + count + ") " + line);
                }
                variable = linePart.substring(0, equalsPos).trim();
                if (variables.containsKey(variable)) {
                    throw new IllegalArgumentException("Duplicate variable definition in " + line);
                }
                definition.append(linePart.substring(equalsPos + 1).trim());
            } else {
                if (variable == null) {
                    throw new IllegalArgumentException("Missing '=' at " + count + ") " + line);
                }
                definition.append(this.bnfLineSeparator).append(linePart);
            }
            if (!terminated) continue;
            variables.put(variable, definition.toString());
            variable = null;
            definition.setLength(0);
        }
        if (variable != null) {
            throw new IllegalArgumentException("Missing ';' at end");
        }
        return variables;
    }
}

