/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;

public class PluralRulesLoader {
    private final Map rulesIdToRules = new HashMap();
    private Map localeIdToRulesId;
    private Map rulesIdToEquivalentULocale;
    public static final PluralRulesLoader loader = new PluralRulesLoader();

    private PluralRulesLoader() {
    }

    public ULocale[] getAvailableULocales() {
        Set keys = this.getLocaleIdToRulesIdMap().keySet();
        ULocale[] locales = new ULocale[keys.size()];
        int n = 0;
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            locales[n++] = ULocale.createCanonical((String)iter.next());
        }
        return locales;
    }

    public ULocale getFunctionalEquivalent(ULocale locale, boolean[] isAvailable) {
        String rulesId;
        if (isAvailable != null && isAvailable.length > 0) {
            String localeId = ULocale.canonicalize(locale.getBaseName());
            Map idMap = this.getLocaleIdToRulesIdMap();
            isAvailable[0] = idMap.containsKey(localeId);
        }
        if ((rulesId = this.getRulesIdForLocale(locale)) == null || rulesId.trim().length() == 0) {
            return ULocale.ROOT;
        }
        ULocale result = (ULocale)this.getRulesIdToEquivalentULocaleMap().get(rulesId);
        if (result == null) {
            return ULocale.ROOT;
        }
        return result;
    }

    private Map getLocaleIdToRulesIdMap() {
        this.checkBuildRulesIdMaps();
        return this.localeIdToRulesId;
    }

    private Map getRulesIdToEquivalentULocaleMap() {
        this.checkBuildRulesIdMaps();
        return this.rulesIdToEquivalentULocale;
    }

    private void checkBuildRulesIdMaps() {
        if (this.localeIdToRulesId == null) {
            try {
                UResourceBundle pluralb = this.getPluralBundle();
                UResourceBundle localeb = pluralb.get("locales");
                this.localeIdToRulesId = new TreeMap();
                this.rulesIdToEquivalentULocale = new HashMap();
                for (int i = 0; i < localeb.getSize(); ++i) {
                    UResourceBundle b = localeb.get(i);
                    String id = b.getKey();
                    String value = b.getString().intern();
                    this.localeIdToRulesId.put(id, value);
                    if (this.rulesIdToEquivalentULocale.containsKey(value)) continue;
                    this.rulesIdToEquivalentULocale.put(value, new ULocale(id));
                }
            }
            catch (MissingResourceException e) {
                this.localeIdToRulesId = new HashMap();
                this.rulesIdToEquivalentULocale = new HashMap();
            }
        }
    }

    public String getRulesIdForLocale(ULocale locale) {
        int ix;
        Map idMap = this.getLocaleIdToRulesIdMap();
        String localeId = ULocale.canonicalize(locale.getBaseName());
        String rulesId = null;
        while (null == (rulesId = (String)idMap.get(localeId)) && (ix = localeId.lastIndexOf("_")) != -1) {
            localeId = localeId.substring(0, ix);
        }
        return rulesId;
    }

    public PluralRules getRulesForRulesId(String rulesId) {
        PluralRules rules = (PluralRules)this.rulesIdToRules.get(rulesId);
        if (rules == null) {
            try {
                UResourceBundle pluralb = this.getPluralBundle();
                UResourceBundle rulesb = pluralb.get("rules");
                UResourceBundle setb = rulesb.get(rulesId);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < setb.getSize(); ++i) {
                    UResourceBundle b = setb.get(i);
                    if (i > 0) {
                        sb.append("; ");
                    }
                    sb.append(b.getKey());
                    sb.append(": ");
                    sb.append(b.getString());
                }
                rules = PluralRules.parseDescription(sb.toString());
            }
            catch (ParseException e) {
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.rulesIdToRules.put(rulesId, rules);
        }
        return rules;
    }

    public UResourceBundle getPluralBundle() throws MissingResourceException {
        return ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt42b", "plurals", ICUResourceBundle.ICU_DATA_CLASS_LOADER, true);
    }

    public PluralRules forLocale(ULocale locale) {
        String rulesId = this.getRulesIdForLocale(locale);
        if (rulesId == null || rulesId.trim().length() == 0) {
            return PluralRules.DEFAULT;
        }
        PluralRules rules = this.getRulesForRulesId(rulesId);
        if (rules == null) {
            rules = PluralRules.DEFAULT;
        }
        return rules;
    }
}

